/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi;

import com.google.common.base.MoreObjects;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegistrationTreeNode<T>
implements Identifiable<YangInstanceIdentifier.PathArgument> {
    private static final Logger LOG = LoggerFactory.getLogger(RegistrationTreeNode.class);
    private final Map<YangInstanceIdentifier.PathArgument, RegistrationTreeNode<T>> children = new HashMap<YangInstanceIdentifier.PathArgument, RegistrationTreeNode<T>>();
    private final Collection<T> registrations = new ArrayList<T>(2);
    private final Collection<T> publicRegistrations = Collections.unmodifiableCollection(this.registrations);
    private final Reference<RegistrationTreeNode<T>> parent;
    private final YangInstanceIdentifier.PathArgument identifier;

    RegistrationTreeNode(RegistrationTreeNode<T> parent, YangInstanceIdentifier.PathArgument identifier) {
        this.parent = new WeakReference<RegistrationTreeNode<RegistrationTreeNode<T>>>(parent);
        this.identifier = identifier;
    }

    public YangInstanceIdentifier.PathArgument getIdentifier() {
        return this.identifier;
    }

    public RegistrationTreeNode<T> getExactChild(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.PathArgument arg) {
        return this.children.get(Objects.requireNonNull(arg));
    }

    public @NonNull Collection<RegistrationTreeNode<T>> getInexactChildren(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.PathArgument arg) {
        Objects.requireNonNull(arg);
        if (arg instanceof YangInstanceIdentifier.NodeWithValue || arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            RegistrationTreeNode<T> child = this.children.get(new YangInstanceIdentifier.NodeIdentifier(arg.getNodeType()));
            if (child == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(child);
        }
        return Collections.emptyList();
    }

    public Collection<T> getRegistrations() {
        return this.publicRegistrations;
    }

    RegistrationTreeNode<T> ensureChild(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.PathArgument child) {
        RegistrationTreeNode<T> potential = this.children.get(Objects.requireNonNull(child));
        if (potential == null) {
            potential = new RegistrationTreeNode<T>(this, child);
            this.children.put(child, potential);
        }
        return potential;
    }

    void addRegistration(@NonNull T registration) {
        this.registrations.add(Objects.requireNonNull(registration));
        LOG.debug("Registration {} added", registration);
    }

    void removeRegistration(@NonNull T registration) {
        this.registrations.remove(Objects.requireNonNull(registration));
        LOG.debug("Registration {} removed", registration);
        this.removeThisIfUnused();
    }

    private void removeThisIfUnused() {
        RegistrationTreeNode<T> p = this.parent.get();
        if (p != null && this.registrations.isEmpty() && this.children.isEmpty()) {
            p.removeChild(this.identifier);
        }
    }

    private void removeChild(YangInstanceIdentifier.PathArgument arg) {
        this.children.remove(arg);
        this.removeThisIfUnused();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("identifier", (Object)this.identifier).add("registrations", this.registrations.size()).add("children", this.children.size()).toString();
    }
}

