/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi;

import com.google.common.collect.ImmutableList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.spi.AbstractDOMForwardedTransactionFactory;
import org.opendaylight.mdsal.dom.spi.DOMDataBrokerTransactionChainImpl;
import org.opendaylight.mdsal.dom.spi.PingPongMergingDOMDataBroker;
import org.opendaylight.mdsal.dom.spi.store.DOMStore;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionChain;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTreeChangePublisher;
import org.opendaylight.yangtools.concepts.Registration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDOMDataBroker
extends AbstractDOMForwardedTransactionFactory<DOMStore>
implements PingPongMergingDOMDataBroker {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDOMDataBroker.class);
    private final AtomicLong txNum = new AtomicLong();
    private final AtomicLong chainNum = new AtomicLong();
    private final @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
    DOMDataBroker.Extension> supportedExtensions;

    protected AbstractDOMDataBroker(Map<LogicalDatastoreType, DOMStore> datastores) {
        super(datastores);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (AbstractDOMDataBroker.isSupported(datastores, DOMStoreTreeChangePublisher.class)) {
            builder.add((Object)new DOMDataBroker.DataTreeChangeExtension(){

                public Registration registerTreeChangeListener(DOMDataTreeIdentifier treeId, DOMDataTreeChangeListener listener) {
                    return this.getPublisher(treeId.datastore()).registerTreeChangeListener(treeId.path(), listener);
                }

                @Deprecated(since="13.0.0", forRemoval=true)
                public Registration registerLegacyTreeChangeListener(DOMDataTreeIdentifier treeId, DOMDataTreeChangeListener listener) {
                    return this.getPublisher(treeId.datastore()).registerLegacyTreeChangeListener(treeId.path(), listener);
                }

                private DOMStoreTreeChangePublisher getPublisher(LogicalDatastoreType datastore) {
                    Object t = AbstractDOMDataBroker.this.getTxFactories().get(datastore);
                    if (t instanceof DOMStoreTreeChangePublisher) {
                        DOMStoreTreeChangePublisher publisher = (DOMStoreTreeChangePublisher)t;
                        return publisher;
                    }
                    throw new IllegalStateException("Publisher for " + String.valueOf(datastore) + " data store is not available");
                }
            });
        }
        if (AbstractDOMDataBroker.isSupported(datastores, DOMDataBroker.CommitCohortExtension.class)) {
            builder.add((path, cohort) -> {
                LogicalDatastoreType dsType = path.datastore();
                Object patt0$temp = this.getTxFactories().get(dsType);
                if (patt0$temp instanceof DOMDataBroker.CommitCohortExtension) {
                    DOMDataBroker.CommitCohortExtension extension = (DOMDataBroker.CommitCohortExtension)patt0$temp;
                    return extension.registerCommitCohort(path, cohort);
                }
                throw new IllegalStateException("Cohort registry for " + String.valueOf(dsType) + " data store is not available");
            });
        }
        this.supportedExtensions = builder.build();
    }

    public final List<DOMDataBroker.Extension> supportedExtensions() {
        return this.supportedExtensions;
    }

    public DOMTransactionChain createTransactionChain() {
        this.checkNotClosed();
        EnumMap<LogicalDatastoreType, DOMStoreTransactionChain> delegates = new EnumMap<LogicalDatastoreType, DOMStoreTransactionChain>(LogicalDatastoreType.class);
        for (Map.Entry entry : this.getTxFactories().entrySet()) {
            delegates.put(entry.getKey(), ((DOMStore)entry.getValue()).createTransactionChain());
        }
        long chainId = this.chainNum.getAndIncrement();
        LOG.debug("Transactoin chain {} created, backing store chains {}", (Object)chainId, delegates);
        return new DOMDataBrokerTransactionChainImpl(chainId, delegates, this);
    }

    @Override
    protected final Object newTransactionIdentifier() {
        return "DOM-" + this.txNum.getAndIncrement();
    }

    private static boolean isSupported(Map<LogicalDatastoreType, DOMStore> datastores, Class<?> expDOMStoreInterface) {
        return datastores.values().stream().allMatch(expDOMStoreInterface::isInstance);
    }
}

