/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.odlext.model.api.ContextReferenceEffectiveStatement;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;

public record ContentRoutedRpcContext(@NonNull QName identity, @NonNull QName leaf) {
    public ContentRoutedRpcContext(@NonNull QName identity, @NonNull QName leaf) {
        Objects.requireNonNull(identity);
        Objects.requireNonNull(identity);
    }

    public static @Nullable ContentRoutedRpcContext forRpc(RpcEffectiveStatement rpc) {
        for (EffectiveStatement stmt : rpc.input().effectiveSubstatements()) {
            if (!(stmt instanceof SchemaTreeEffectiveStatement)) continue;
            SchemaTreeEffectiveStatement schemaStmt = (SchemaTreeEffectiveStatement)stmt;
            Optional context = stmt.findFirstEffectiveSubstatementArgument(ContextReferenceEffectiveStatement.class);
            if (!context.isPresent()) continue;
            return new ContentRoutedRpcContext((QName)context.orElseThrow(), (QName)schemaStmt.argument());
        }
        return null;
    }
}

