/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.spi.AbstractDOMDataBroker;
import org.opendaylight.mdsal.dom.spi.AbstractDOMForwardedTransactionFactory;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionChain;
import org.opendaylight.yangtools.yang.common.Empty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DOMDataBrokerTransactionChainImpl
extends AbstractDOMForwardedTransactionFactory<DOMStoreTransactionChain>
implements DOMTransactionChain {
    private static final AtomicIntegerFieldUpdater<DOMDataBrokerTransactionChainImpl> COUNTER_UPDATER = AtomicIntegerFieldUpdater.newUpdater(DOMDataBrokerTransactionChainImpl.class, "counter");
    private static final AtomicReferenceFieldUpdater<DOMDataBrokerTransactionChainImpl, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DOMDataBrokerTransactionChainImpl.class, State.class, "state");
    private static final Logger LOG = LoggerFactory.getLogger(DOMDataBrokerTransactionChainImpl.class);
    private final @NonNull SettableFuture<Empty> future = SettableFuture.create();
    private final AtomicLong txNum = new AtomicLong();
    private final AbstractDOMDataBroker broker;
    private final long chainId;
    private volatile State state = State.RUNNING;
    private volatile int counter = 0;

    DOMDataBrokerTransactionChainImpl(long chainId, Map<LogicalDatastoreType, DOMStoreTransactionChain> chains, AbstractDOMDataBroker broker) {
        super(chains);
        this.chainId = chainId;
        this.broker = Objects.requireNonNull(broker);
    }

    private void checkNotFailed() {
        Preconditions.checkState((this.state != State.FAILED ? 1 : 0) != 0, (Object)"Transaction chain has failed");
    }

    public ListenableFuture<Empty> future() {
        return this.future;
    }

    @Override
    protected Object newTransactionIdentifier() {
        return "DOM-CHAIN-" + this.chainId + "-" + this.txNum.getAndIncrement();
    }

    @Override
    protected FluentFuture<? extends CommitInfo> commit(final DOMDataTreeWriteTransaction transaction, DOMStoreThreePhaseCommitCohort cohort) {
        this.checkNotFailed();
        this.checkNotClosed();
        FluentFuture<CommitInfo> ret = this.broker.commit(transaction, cohort);
        COUNTER_UPDATER.incrementAndGet(this);
        ret.addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                DOMDataBrokerTransactionChainImpl.this.transactionCompleted();
            }

            public void onFailure(Throwable throwable) {
                DOMDataBrokerTransactionChainImpl.this.transactionFailed(transaction, throwable);
            }
        }, MoreExecutors.directExecutor());
        return ret;
    }

    @Override
    public void close() {
        boolean success = STATE_UPDATER.compareAndSet(this, State.RUNNING, State.CLOSING);
        if (!success) {
            LOG.debug("Chain {} is no longer running", (Object)this);
            return;
        }
        super.close();
        for (DOMStoreTransactionChain subChain : this.getTxFactories().values()) {
            subChain.close();
        }
        if (this.counter == 0) {
            this.finishClose();
        }
    }

    private void finishClose() {
        this.state = State.CLOSED;
        this.future.set((Object)Empty.value());
    }

    private void transactionCompleted() {
        if (COUNTER_UPDATER.decrementAndGet(this) == 0 && this.state == State.CLOSING) {
            this.finishClose();
        }
    }

    private void transactionFailed(DOMDataTreeWriteTransaction tx, Throwable cause) {
        this.state = State.FAILED;
        LOG.debug("Transaction chain {}\u00a0failed.", (Object)this, (Object)cause);
        this.future.setException(cause);
    }

    private static enum State {
        RUNNING,
        CLOSING,
        CLOSED,
        FAILED;

    }
}

