/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;

@Beta
@NonNullByDefault
public final class DefaultDOMRpcResult
implements DOMRpcResult,
Immutable,
Serializable {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Interfaces do not specify Serializable")
    private final @Nullable ContainerNode value;
    private final Collection<? extends RpcError> errors;

    public DefaultDOMRpcResult(RpcError error) {
        this(null, List.of(error));
    }

    public DefaultDOMRpcResult(RpcError ... errors) {
        this(null, List.of(errors));
    }

    public DefaultDOMRpcResult(@Nullable ContainerNode result) {
        this(result, List.of());
    }

    public DefaultDOMRpcResult(ContainerNode value, RpcError error) {
        this(value, List.of(error));
    }

    public DefaultDOMRpcResult(ContainerNode value, RpcError ... errors) {
        this(value, List.of(errors));
    }

    public DefaultDOMRpcResult(@Nullable ContainerNode result, Collection<? extends RpcError> errors) {
        this.value = result;
        this.errors = Objects.requireNonNull(errors);
    }

    public DefaultDOMRpcResult(Collection<RpcError> errors) {
        this(null, errors);
    }

    public static DOMRpcResult ofMalformedMessage(Exception cause) {
        return new DefaultDOMRpcResult(RpcResultBuilder.newError((ErrorType)ErrorType.RPC, (ErrorTag)ErrorTag.MALFORMED_MESSAGE, (String)cause.getMessage(), null, null, (Throwable)Objects.requireNonNull(cause)));
    }

    public Collection<? extends RpcError> errors() {
        return this.errors;
    }

    public @Nullable ContainerNode value() {
        return this.value;
    }

    public int hashCode() {
        int ret = this.errors.hashCode();
        ContainerNode local = this.value;
        if (local != null) {
            ret = 31 * ret + local.hashCode();
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof DefaultDOMRpcResult)) return false;
        DefaultDOMRpcResult other = (DefaultDOMRpcResult)obj;
        if (!this.errors.equals(other.errors)) return false;
        if (!Objects.equals(this.value, other.value)) return false;
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("value", (Object)this.value).add("errors", this.errors.isEmpty() ? null : this.errors).toString();
    }
}

