/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.StampedLock;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRegistrationTree<T> {
    private final @NonNull Node<T> rootNode = new Node(null, null);
    private final @NonNull Lock writeLock;
    private final @NonNull Lock readLock;

    protected AbstractRegistrationTree() {
        StampedLock lock = new StampedLock();
        this.readLock = lock.asReadLock();
        this.writeLock = lock.asWriteLock();
    }

    protected final void takeLock() {
        this.writeLock.lock();
    }

    protected final void releaseLock() {
        this.writeLock.unlock();
    }

    protected final @NonNull Node<T> findNodeFor(@NonNull Iterable<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.PathArgument> path) {
        Node<T> walkNode = this.rootNode;
        for (YangInstanceIdentifier.PathArgument arg : path) {
            walkNode = walkNode.ensureChild(arg);
        }
        return walkNode;
    }

    protected final void addRegistration(@NonNull Node<T> node, @NonNull T registration) {
        node.addRegistration(registration);
    }

    protected final void removeRegistration(@NonNull Node<T> node, @NonNull T registration) {
        this.writeLock.lock();
        try {
            node.removeRegistration(registration);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected final @NonNull Snapshot<T> takeSnapshot() {
        this.readLock.lock();
        return new Snapshot<T>(this.readLock, this.rootNode);
    }

    protected static final class Node<T>
    implements Identifiable<YangInstanceIdentifier.PathArgument> {
        private static final Logger LOG = LoggerFactory.getLogger(Node.class);
        private final Map<YangInstanceIdentifier.PathArgument, Node<T>> children = new HashMap<YangInstanceIdentifier.PathArgument, Node<T>>();
        private final List<T> registrations = new ArrayList<T>(2);
        private final List<T> publicRegistrations = Collections.unmodifiableList(this.registrations);
        private final Reference<Node<T>> parent;
        private final YangInstanceIdentifier.PathArgument identifier;

        Node(Node<T> parent, YangInstanceIdentifier.PathArgument identifier) {
            this.parent = new WeakReference<Node<Node<T>>>(parent);
            this.identifier = identifier;
        }

        public YangInstanceIdentifier.PathArgument getIdentifier() {
            return this.identifier;
        }

        public @Nullable Node<T> getExactChild(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull YangInstanceIdentifier.PathArgument arg) {
            return this.children.get(Objects.requireNonNull(arg));
        }

        public @NonNull Collection<Node<T>> getInexactChildren(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull YangInstanceIdentifier.PathArgument arg) {
            Objects.requireNonNull(arg);
            if (arg instanceof YangInstanceIdentifier.NodeWithValue || arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
                Node<T> child = this.children.get(new YangInstanceIdentifier.NodeIdentifier(arg.getNodeType()));
                return child == null ? List.of() : Collections.singletonList(child);
            }
            return List.of();
        }

        public Collection<T> getRegistrations() {
            return this.publicRegistrations;
        }

        @VisibleForTesting
        @NonNull Node<T> ensureChild(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull YangInstanceIdentifier.PathArgument child) {
            return this.children.computeIfAbsent(Objects.requireNonNull(child), key -> new Node<T>(this, (YangInstanceIdentifier.PathArgument)key));
        }

        @VisibleForTesting
        void addRegistration(@NonNull T registration) {
            this.registrations.add(Objects.requireNonNull(registration));
            LOG.debug("Registration {} added", registration);
        }

        @VisibleForTesting
        void removeRegistration(@NonNull T registration) {
            if (this.registrations.remove(Objects.requireNonNull(registration))) {
                LOG.debug("Registration {} removed", registration);
                this.removeThisIfUnused();
            }
        }

        private void removeThisIfUnused() {
            Node<T> p = this.parent.get();
            if (p != null && this.registrations.isEmpty() && this.children.isEmpty()) {
                p.removeChild(this.identifier);
            }
        }

        private void removeChild(YangInstanceIdentifier.PathArgument arg) {
            this.children.remove(arg);
            this.removeThisIfUnused();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("identifier", (Object)this.identifier).add("registrations", this.registrations.size()).add("children", this.children.size()).toString();
        }
    }

    @NonNullByDefault
    protected static final class Snapshot<T>
    extends AbstractRegistration {
        private final Node<T> node;
        private final Lock lock;

        Snapshot(Lock lock, Node<T> node) {
            this.lock = Objects.requireNonNull(lock);
            this.node = Objects.requireNonNull(node);
        }

        public Node<T> getRootNode() {
            return this.node;
        }

        protected void removeRegistration() {
            this.lock.unlock();
        }
    }
}

