/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.eos.binding.dom.adapter;

import com.google.common.annotations.Beta;
import java.util.Optional;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.eos.binding.api.Entity;
import org.opendaylight.mdsal.eos.binding.api.EntityOwnershipCandidateRegistration;
import org.opendaylight.mdsal.eos.binding.api.EntityOwnershipListener;
import org.opendaylight.mdsal.eos.binding.api.EntityOwnershipListenerRegistration;
import org.opendaylight.mdsal.eos.binding.api.EntityOwnershipService;
import org.opendaylight.mdsal.eos.binding.dom.adapter.BindingDOMEntityOwnershipServiceAdapter;
import org.opendaylight.mdsal.eos.common.api.CandidateAlreadyRegisteredException;
import org.opendaylight.mdsal.eos.common.api.EntityOwnershipState;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(immediate=true, property={"type=default"})
public final class OSGiEntityOwnershipService
implements EntityOwnershipService {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiEntityOwnershipService.class);
    @Reference
    DOMEntityOwnershipService domService = null;
    @Reference
    AdapterContext adapterContext = null;
    private BindingDOMEntityOwnershipServiceAdapter delegate;

    public EntityOwnershipCandidateRegistration registerCandidate(Entity entity) throws CandidateAlreadyRegisteredException {
        return this.delegate.registerCandidate(entity);
    }

    public EntityOwnershipListenerRegistration registerListener(String entityType, EntityOwnershipListener listener) {
        return this.delegate.registerListener(entityType, listener);
    }

    public Optional<EntityOwnershipState> getOwnershipState(Entity forEntity) {
        return this.delegate.getOwnershipState(forEntity);
    }

    public boolean isCandidateRegistered(Entity forEntity) {
        return this.delegate.isCandidateRegistered(forEntity);
    }

    @Activate
    void activate() {
        LOG.info("Entity Ownership Service adapter starting");
        this.delegate = new BindingDOMEntityOwnershipServiceAdapter(this.domService, this.adapterContext);
        LOG.info("Entity Ownership Service adapter started");
    }

    @Deactivate
    void deactivate() {
        LOG.info("Entity Ownership Service adapter stopping");
        this.delegate.close();
        this.delegate = null;
        LOG.info("Entity Ownership Service adapter stopped");
    }
}

