package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Dscp;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * IP header fields common to ipv4 and ipv6
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-packet-fields</b>
 * <pre>
 * grouping acl-ip-header-fields {
 *   leaf dscp {
 *     type inet:dscp;
 *   }
 *   leaf protocol {
 *     type uint8;
 *   }
 *   uses acl-transport-header-fields;
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-packet-fields/acl-ip-header-fields</i>
 *
 */
public interface AclIpHeaderFields
    extends
    DataObject,
    AclTransportHeaderFields
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("acl-ip-header-fields");

    @Override
    Class<? extends AclIpHeaderFields> implementedInterface();
    
    /**
     * Value of dscp.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Dscp</code> <code>dscp</code>, or <code>null</code> if not present
     */
    Dscp getDscp();
    
    /**
     * Internet Protocol number.
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint8</code> <code>protocol</code>, or <code>null</code> if not present
     */
    Uint8 getProtocol();

}

