package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Fields in IPv4 header.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-packet-fields</b>
 * <pre>
 * grouping acl-ipv4-header-fields {
 *   leaf destination-ipv4-network {
 *     type inet:ipv4-prefix;
 *   }
 *   leaf source-ipv4-network {
 *     type inet:ipv4-prefix;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-packet-fields/acl-ipv4-header-fields</i>
 *
 */
public interface AclIpv4HeaderFields
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("acl-ipv4-header-fields");

    @Override
    Class<? extends AclIpv4HeaderFields> implementedInterface();
    
    /**
     * Destination IPv4 address prefix.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix</code> <code>destinationIpv4Network</code>, or <code>null</code> if not present
     */
    Ipv4Prefix getDestinationIpv4Network();
    
    /**
     * Source IPv4 address prefix.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix</code> <code>sourceIpv4Network</code>, or <code>null</code> if not present
     */
    Ipv4Prefix getSourceIpv4Network();

}

