package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6FlowLabel;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Prefix;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Fields in IPv6 header
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-packet-fields</b>
 * <pre>
 * grouping acl-ipv6-header-fields {
 *   leaf destination-ipv6-network {
 *     type inet:ipv6-prefix;
 *   }
 *   leaf source-ipv6-network {
 *     type inet:ipv6-prefix;
 *   }
 *   leaf flow-label {
 *     type inet:ipv6-flow-label;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-packet-fields/acl-ipv6-header-fields</i>
 *
 */
public interface AclIpv6HeaderFields
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("acl-ipv6-header-fields");

    @Override
    Class<? extends AclIpv6HeaderFields> implementedInterface();
    
    /**
     * Destination IPv6 address prefix.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Prefix</code> <code>destinationIpv6Network</code>, or <code>null</code> if not present
     */
    Ipv6Prefix getDestinationIpv6Network();
    
    /**
     * Source IPv6 address prefix.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Prefix</code> <code>sourceIpv6Network</code>, or <code>null</code> if not present
     */
    Ipv6Prefix getSourceIpv6Network();
    
    /**
     * IPv6 Flow label.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6FlowLabel</code> <code>flowLabel</code>, or <code>null</code> if not present
     */
    Ipv6FlowLabel getFlowLabel();

}

