package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.acl.transport.header.fields.DestinationPortRange;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.acl.transport.header.fields.SourcePortRange;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Transport header fields
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-packet-fields</b>
 * <pre>
 * grouping acl-transport-header-fields {
 *   container source-port-range {
 *     presence "Enables setting source port range";
 *     leaf lower-port {
 *       type inet:port-number;
 *     }
 *     leaf upper-port {
 *       type inet:port-number;
 *       must ". &gt;= ../lower-port" {
 *         error-message
 *           "The upper-port must be greater than or equal to lower-port";
 *       }
 *     }
 *   }
 *   container destination-port-range {
 *     presence "Enables setting destination port range";
 *     leaf lower-port {
 *       type inet:port-number;
 *     }
 *     leaf upper-port {
 *       type inet:port-number;
 *       must ". &gt;= ../lower-port" {
 *         error-message
 *           "The upper-port must be greater than or equal to lower-port";
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-packet-fields/acl-transport-header-fields</i>
 *
 */
public interface AclTransportHeaderFields
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("acl-transport-header-fields");

    @Override
    Class<? extends AclTransportHeaderFields> implementedInterface();
    
    /**
     * Inclusive range representing source ports to be used. When only lower-port is
     * present, it represents a single port.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.acl.transport.header.fields.SourcePortRange</code> <code>sourcePortRange</code>, or <code>null</code> if not present
     */
    SourcePortRange getSourcePortRange();
    
    /**
     * Inclusive range representing destination ports to be used. When only lower-port
     * is present, it represents a single port.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.acl.transport.header.fields.DestinationPortRange</code> <code>destinationPortRange</code>, or <code>null</code> if not present
     */
    DestinationPortRange getDestinationPortRange();

}

