package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.acl.transport.header.fields;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.AclTransportHeaderFields;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Inclusive range representing source ports to be used. When only lower-port is 
 * present, it represents a single port.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-packet-fields</b>
 * <pre>
 * container source-port-range {
 *   presence "Enables setting source port range";
 *   leaf lower-port {
 *     type inet:port-number;
 *   }
 *   leaf upper-port {
 *     type inet:port-number;
 *     must ". &gt;= ../lower-port" {
 *       error-message
 *         "The upper-port must be greater than or equal to lower-port";
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-packet-fields/acl-transport-header-fields/source-port-range</i>
 *
 * <p>To create instances of this class use {@link SourcePortRangeBuilder}.
 * @see SourcePortRangeBuilder
 *
 */
public interface SourcePortRange
    extends
    ChildOf<AclTransportHeaderFields>,
    Augmentable<SourcePortRange>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("source-port-range");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.acl.transport.header.fields.SourcePortRange> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.acl.transport.header.fields.SourcePortRange.class;
    }
    
    /**
     * Lower boundary for port.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber</code> <code>lowerPort</code>, or <code>null</code> if not present
     */
    PortNumber getLowerPort();
    
    /**
     * Upper boundary for port . If existing, the upper port must be greater or equal
     * to lower-port.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber</code> <code>upperPort</code>, or <code>null</code> if not present
     */
    PortNumber getUpperPort();

}

