package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019;
import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class DataResourceIdentifier
 implements TypeObject, Serializable {
    private static final long serialVersionUID = -4890890909619681200L;
    private final String _value;

    private static void check_valueLength(final String value) {
        final int length = value.length();
        if (length >= 1) {
            return;
        }
        CodeHelpers.throwInvalidLength("[[1..2147483647]]", value);
    }

    @ConstructorProperties("value")
    public DataResourceIdentifier(String _value) {
        if (_value != null) {
            check_valueLength(_value);
        }
    
        CodeHelpers.requireValue(_value);
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public DataResourceIdentifier(DataResourceIdentifier source) {
        this._value = source._value;
    }

    public static DataResourceIdentifier getDefaultInstance(String defaultValue) {
        return new DataResourceIdentifier(defaultValue);
    }

    public String getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        DataResourceIdentifier other = (DataResourceIdentifier) obj;
        if (!Objects.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(DataResourceIdentifier.class);
        CodeHelpers.appendValue(helper, "_value", _value);
        return helper.toString();
    }
}

