package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.io.Serializable;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class DatastoreIdentifier
 implements TypeObject, Serializable {
    private static final long serialVersionUID = -1485497541314556057L;
    public enum Enumeration implements org.opendaylight.yangtools.yang.binding.Enumeration {
        /**
         * Identifies the NETCONF shared candidate datastore.
         *
         */
        Candidate(0, "candidate"),
        
        /**
         * Identifies the NETCONF running datastore.
         *
         */
        Running(1, "running"),
        
        /**
         * Identifies the NETCONF startup datastore.
         *
         */
        Startup(2, "startup")
        ;
    
        private static final Map<String, Enumeration> NAME_MAP;
        private static final Map<Integer, Enumeration> VALUE_MAP;
    
        static {
            final Builder<String, Enumeration> nb = ImmutableMap.builder();
            final Builder<Integer, Enumeration> vb = ImmutableMap.builder();
            for (Enumeration enumItem : Enumeration.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private Enumeration(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding Enumeration item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<Enumeration> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding Enumeration item, or null if no such item exists
         */
        public static Enumeration forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }
    private final Enumeration _enumeration;
    private final String _string;


    public DatastoreIdentifier(Enumeration _enumeration) {
        super();
        this._enumeration = _enumeration;
        this._string = null;
    }
    
    public DatastoreIdentifier(String _string) {
        super();
        this._string = _string;
        this._enumeration = null;
    }
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public DatastoreIdentifier(DatastoreIdentifier source) {
        this._enumeration = source._enumeration;
        this._string = source._string;
    }
    
    /**
     * Return a String representing the value of this union.
     *
     * @return String representation of this union's value.
     */
    public String stringValue() {
        if (_enumeration != null) {
            return _enumeration.toString();
        }
        if (_string != null) {
            return _string;
        }
    
        throw new IllegalStateException("No value assinged");
    }


    public Enumeration getEnumeration() {
        return _enumeration;
    }
    
    public String getString() {
        return _string;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_enumeration);
        result = prime * result + Objects.hashCode(_string);
        return result;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        DatastoreIdentifier other = (DatastoreIdentifier) obj;
        if (!Objects.equals(_enumeration, other._enumeration)) {
            return false;
        }
        if (!Objects.equals(_string, other._string)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(DatastoreIdentifier.class);
        CodeHelpers.appendValue(helper, "_enumeration", _enumeration);
        CodeHelpers.appendValue(helper, "_string", _string);
        return helper.toString();
    }
}

