package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * A grouping that contains a YANG container representing the syntax and semantics 
 * of a YANG Patch errors report within a response message.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-restconf</b>
 * <pre>
 * grouping errors {
 *   container errors {
 *     config false;
 *     list error {
 *       leaf error-type {
 *         type enumeration {
 *           enum transport {
 *           }
 *           enum rpc {
 *           }
 *           enum protocol {
 *           }
 *           enum application {
 *           }
 *         }
 *       }
 *       leaf error-tag {
 *         type string;
 *       }
 *       leaf error-app-tag {
 *         type string;
 *       }
 *       leaf error-path {
 *         type data-resource-identifier;
 *       }
 *       leaf error-message {
 *         type string;
 *       }
 *       container error-info {
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-restconf/errors</i>
 *
 */
public interface Errors
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("errors");

    @Override
    Class<? extends Errors> implementedInterface();
    
    /**
     * Represents an error report returned by the server if a request results in an
     * error.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.errors.Errors</code> <code>errors</code>, or <code>null</code> if not present
     */
    org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.errors.@Nullable Errors getErrors();

}

