package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * A grouping that contains a YANG container representing the syntax and semantics 
 * of the RESTCONF API resource.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-restconf</b>
 * <pre>
 * grouping restconf {
 *   container restconf {
 *     container config {
 *     }
 *     container operational {
 *     }
 *     container modules {
 *       list module {
 *         key "name revision";
 *         leaf name {
 *           type yang:yang-identifier;
 *         }
 *         leaf revision {
 *           type union {
 *             type revision-identifier;
 *             type string {
 *               length 0;
 *             }
 *           }
 *         }
 *         leaf namespace {
 *           type inet:uri;
 *         }
 *         leaf-list feature {
 *           type yang:yang-identifier;
 *         }
 *         leaf-list deviation {
 *           type yang:yang-identifier;
 *         }
 *       }
 *     }
 *     container operations {
 *     }
 *     container streams {
 *       list stream {
 *         key name;
 *         leaf name {
 *           type string;
 *         }
 *         leaf description {
 *           type string;
 *         }
 *         leaf replay-support {
 *           type boolean;
 *         }
 *         leaf replay-log-creation-time {
 *           type yang:date-and-time;
 *         }
 *         leaf events {
 *           type empty;
 *         }
 *       }
 *     }
 *     leaf version {
 *       type enumeration {
 *         enum 1.0 {
 *         }
 *       }
 *       config false;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-restconf/restconf</i>
 *
 */
public interface Restconf
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("restconf");

    @Override
    Class<? extends Restconf> implementedInterface();
    
    /**
     * Conceptual container representing the application/yang.api resource type.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.Restconf</code> <code>restconf</code>, or <code>null</code> if not present
     */
    org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.@Nullable Restconf getRestconf();

}

