package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * A grouping that contains a YANG container representing the syntax and semantics 
 * of a YANG Patch edit request message.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-restconf</b>
 * <pre>
 * grouping yang-patch {
 *   container yang-patch {
 *     leaf patch-id {
 *       type string;
 *     }
 *     leaf comment {
 *       type string {
 *         length "0 .. 1024";
 *       }
 *     }
 *     list edit {
 *       key edit-id;
 *       ordered-by user;
 *       leaf edit-id {
 *         type string;
 *       }
 *       leaf operation {
 *         type enumeration {
 *           enum create {
 *           }
 *           enum delete {
 *           }
 *           enum insert {
 *           }
 *           enum merge {
 *           }
 *           enum move {
 *           }
 *           enum replace {
 *           }
 *           enum remove {
 *           }
 *         }
 *       }
 *       leaf target {
 *         type data-resource-identifier;
 *       }
 *       leaf point {
 *         when "(../operation = 'insert' or ../operation = 'move') and (../where = 'before' or ../where = 'after')" {
 *         }
 *         type data-resource-identifier;
 *       }
 *       leaf where {
 *         when "../operation = 'insert' or ../operation = 'move'" {
 *         }
 *         type enumeration {
 *           enum before {
 *           }
 *           enum after {
 *           }
 *           enum first {
 *           }
 *           enum last {
 *           }
 *         }
 *         default last;
 *       }
 *       anyxml value {
 *         when "(../operation = 'create' or ../operation = 'merge' or ../operation = 'replace' or ../operation = 'insert')" {
 *         }
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-restconf/yang-patch</i>
 *
 */
public interface YangPatch
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("yang-patch");

    @Override
    Class<? extends YangPatch> implementedInterface();
    
    /**
     * Represents a conceptual sequence of datastore edits, called a patch. Each patch
     * is given a client-assigned patch identifier. Each edit MUST be applied in
     * ascending order, and all edits MUST be applied. If any errors occur, then the
     * target datastore MUST NOT be changed by the patch operation. A patch MUST be
     * validated by the server to be a well-formed message before any of the patch
     * edits are validated or attempted. YANG datastore validation (defined in RFC
     * 6020, section 8.3.3) is performed after all edits have been individually
     * validated. It is possible for a datastore constraint violation to occur due to
     * any node in the datastore, including nodes not included in the edit list. Any
     * validation errors MUST be reported in the reply message.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.YangPatch</code> <code>yangPatch</code>, or <code>null</code> if not present
     */
    org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.@Nullable YangPatch getYangPatch();

}

