package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * A grouping that contains a YANG container representing the syntax and semantics 
 * of YANG Patch status response message.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-restconf</b>
 * <pre>
 * grouping yang-patch-status {
 *   container yang-patch-status {
 *     leaf patch-id {
 *       type string;
 *     }
 *     choice global-status {
 *       case global-errors {
 *         uses errors;
 *       }
 *       case ok {
 *         leaf ok {
 *           type empty;
 *         }
 *       }
 *     }
 *     container edit-status {
 *       list edit {
 *         key edit-id;
 *         leaf edit-id {
 *           type string;
 *         }
 *         choice edit-status-choice {
 *           case ok {
 *             leaf ok {
 *               type empty;
 *             }
 *           }
 *           case location {
 *             leaf location {
 *               type inet:uri;
 *             }
 *           }
 *           case errors {
 *             uses errors;
 *           }
 *         }
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-restconf/yang-patch-status</i>
 *
 */
public interface YangPatchStatus
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("yang-patch-status");

    @Override
    Class<? extends YangPatchStatus> implementedInterface();
    
    /**
     * A container representing the response message sent by the server after a YANG
     * Patch edit request message has been processed.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.status.YangPatchStatus</code> <code>yangPatchStatus</code>, or <code>null</code> if not present
     */
    org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.status.@Nullable YangPatchStatus getYangPatchStatus();

}

