package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.errors;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.errors.errors.Error;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Represents an error report returned by the server if a request results in an 
 * error.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-restconf</b>
 * <pre>
 * container errors {
 *   config false;
 *   list error {
 *     leaf error-type {
 *       type enumeration {
 *         enum transport {
 *         }
 *         enum rpc {
 *         }
 *         enum protocol {
 *         }
 *         enum application {
 *         }
 *       }
 *     }
 *     leaf error-tag {
 *       type string;
 *     }
 *     leaf error-app-tag {
 *       type string;
 *     }
 *     leaf error-path {
 *       type data-resource-identifier;
 *     }
 *     leaf error-message {
 *       type string;
 *     }
 *     container error-info {
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-restconf/errors/errors</i>
 *
 * <p>To create instances of this class use {@link ErrorsBuilder}.
 * @see ErrorsBuilder
 *
 */
public interface Errors
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.Errors>,
    Augmentable<Errors>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("errors");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.errors.Errors> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.errors.Errors.class;
    }
    
    /**
     * An entry containing information about one specific error that occurred while
     * processing a RESTCONF request.
     *
     *
     *
     * @return <code>java.util.List</code> <code>error</code>, or <code>null</code> if not present
     */
    @Nullable List<Error> getError();
    
    /**
     * @return <code>java.util.List</code> <code>error</code>, or an empty list if it is not present
     */
    default @NonNull List<Error> nonnullError() {
        return CodeHelpers.nonnull(getError());
    }

}

