package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.notification;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * RESTCONF notification message wrapper.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-restconf</b>
 * <pre>
 * container notification {
 *   leaf event-time {
 *     type yang:date-and-time;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-restconf/notification/notification</i>
 *
 * <p>To create instances of this class use {@link NotificationBuilder}.
 * @see NotificationBuilder
 *
 */
public interface Notification
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.Notification>,
    Augmentable<Notification>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("notification");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.notification.Notification> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.notification.Notification.class;
    }
    
    /**
     * The time the event was generated by the event source.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime</code> <code>eventTime</code>, or <code>null</code> if not present
     */
    @Nullable DateAndTime getEventTime();

}

