package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Config;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Modules;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Operational;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Operations;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Streams;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Conceptual container representing the application/yang.api resource type.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-restconf</b>
 * <pre>
 * container restconf {
 *   container config {
 *   }
 *   container operational {
 *   }
 *   container modules {
 *     list module {
 *       key "name revision";
 *       leaf name {
 *         type yang:yang-identifier;
 *       }
 *       leaf revision {
 *         type union {
 *           type revision-identifier;
 *           type string {
 *             length 0;
 *           }
 *         }
 *       }
 *       leaf namespace {
 *         type inet:uri;
 *       }
 *       leaf-list feature {
 *         type yang:yang-identifier;
 *       }
 *       leaf-list deviation {
 *         type yang:yang-identifier;
 *       }
 *     }
 *   }
 *   container operations {
 *   }
 *   container streams {
 *     list stream {
 *       key name;
 *       leaf name {
 *         type string;
 *       }
 *       leaf description {
 *         type string;
 *       }
 *       leaf replay-support {
 *         type boolean;
 *       }
 *       leaf replay-log-creation-time {
 *         type yang:date-and-time;
 *       }
 *       leaf events {
 *         type empty;
 *       }
 *     }
 *   }
 *   leaf version {
 *     type enumeration {
 *       enum 1.0 {
 *       }
 *     }
 *     config false;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-restconf/restconf/restconf</i>
 *
 * <p>To create instances of this class use {@link RestconfBuilder}.
 * @see RestconfBuilder
 *
 */
public interface Restconf
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.Restconf>,
    Augmentable<Restconf>
{


    public enum Version implements Enumeration {
        /**
         * Version 1.0 of the RESTCONF protocol.
         *
         */
        _10(0, "1.0")
        ;
    
        private static final Map<String, Version> NAME_MAP;
        private static final Map<Integer, Version> VALUE_MAP;
    
        static {
            final Builder<String, Version> nb = ImmutableMap.builder();
            final Builder<Integer, Version> vb = ImmutableMap.builder();
            for (Version enumItem : Version.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private Version(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding Version item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<Version> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding Version item, or null if no such item exists
         */
        public static Version forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }

    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("restconf");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.Restconf> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.Restconf.class;
    }
    
    /**
     * Container representing the application/yang.datastore resource type. Represents
     * the conceptual root of the unified configuration datastore containing YANG data
     * nodes. The child nodes of this container are configuration data resources
     * (application/yang.data) defined as top-level YANG data nodes from the modules
     * advertised by the server in /restconf/modules.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Config</code> <code>config</code>, or <code>null</code> if not present
     */
    @Nullable Config getConfig();
    
    /**
     * Container representing the application/yang.datastore resource type. Represents
     * the conceptual root of the operational data supported by the server. The child
     * nodes of this container are operational data resources (application/yang.data)
     * defined as top-level YANG data nodes from the modules advertised by the server
     * in /restconf/modules.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Operational</code> <code>operational</code>, or <code>null</code> if not present
     */
    @Nullable Operational getOperational();
    
    /**
     * Contains a list of module description entries. These modules are currently
     * loaded into the server.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Modules</code> <code>modules</code>, or <code>null</code> if not present
     */
    @Nullable Modules getModules();
    
    /**
     * Container for all operation resources (application/yang.operation), Each
     * resource is represented as an empty leaf with the name of the RPC operation from
     * the YANG rpc statement. E.g.; POST /restconf/operations/show-log-errors leaf
     * show-log-errors { type empty; } 
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Operations</code> <code>operations</code>, or <code>null</code> if not present
     */
    @Nullable Operations getOperations();
    
    /**
     * Container representing the notification event streams supported by the server.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Streams</code> <code>streams</code>, or <code>null</code> if not present
     */
    @Nullable Streams getStreams();
    
    /**
     * Contains the RESTCONF protocol version.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.Restconf.Version</code> <code>version</code>, or <code>null</code> if not present
     */
    @Nullable Version getVersion();

}

