package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.Restconf;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.modules.Module;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Contains a list of module description entries. These modules are currently 
 * loaded into the server.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-restconf</b>
 * <pre>
 * container modules {
 *   list module {
 *     key "name revision";
 *     leaf name {
 *       type yang:yang-identifier;
 *     }
 *     leaf revision {
 *       type union {
 *         type revision-identifier;
 *         type string {
 *           length 0;
 *         }
 *       }
 *     }
 *     leaf namespace {
 *       type inet:uri;
 *     }
 *     leaf-list feature {
 *       type yang:yang-identifier;
 *     }
 *     leaf-list deviation {
 *       type yang:yang-identifier;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-restconf/restconf/restconf/modules</i>
 *
 * <p>To create instances of this class use {@link ModulesBuilder}.
 * @see ModulesBuilder
 *
 */
public interface Modules
    extends
    ChildOf<Restconf>,
    Augmentable<Modules>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("modules");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Modules> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Modules.class;
    }
    
    /**
     * Each entry represents one module currently supported by the server.
     *
     *
     *
     * @return <code>java.util.List</code> <code>module</code>, or <code>null</code> if not present
     */
    @Nullable List<Module> getModule();
    
    /**
     * @return <code>java.util.List</code> <code>module</code>, or an empty list if it is not present
     */
    default @NonNull List<Module> nonnullModule() {
        return CodeHelpers.nonnull(getModule());
    }

}

