package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.Restconf;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Container representing the application/yang.datastore resource type. Represents 
 * the conceptual root of the operational data supported by the server. The child 
 * nodes of this container are operational data resources (application/yang.data) 
 * defined as top-level YANG data nodes from the modules advertised by the server 
 * in /restconf/modules.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-restconf</b>
 * <pre>
 * container operational {
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-restconf/restconf/restconf/operational</i>
 *
 * <p>To create instances of this class use {@link OperationalBuilder}.
 * @see OperationalBuilder
 *
 */
public interface Operational
    extends
    ChildOf<Restconf>,
    Augmentable<Operational>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("operational");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Operational> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Operational.class;
    }

}

