package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.Restconf;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Container for all operation resources (application/yang.operation), Each 
 * resource is represented as an empty leaf with the name of the RPC operation 
 * the YANG rpc statement. E.g.; POST /restconf/operations/show-log-errors leaf 
 * show-log-errors { type empty; } 
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-restconf</b>
 * <pre>
 * container operations {
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-restconf/restconf/restconf/operations</i>
 *
 * <p>To create instances of this class use {@link OperationsBuilder}.
 * @see OperationsBuilder
 *
 */
public interface Operations
    extends
    ChildOf<Restconf>,
    Augmentable<Operations>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("operations");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Operations> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Operations.class;
    }

}

