package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.Restconf;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.streams.Stream;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Container representing the notification event streams supported by the server.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-restconf</b>
 * <pre>
 * container streams {
 *   list stream {
 *     key name;
 *     leaf name {
 *       type string;
 *     }
 *     leaf description {
 *       type string;
 *     }
 *     leaf replay-support {
 *       type boolean;
 *     }
 *     leaf replay-log-creation-time {
 *       type yang:date-and-time;
 *     }
 *     leaf events {
 *       type empty;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-restconf/restconf/restconf/streams</i>
 *
 * <p>To create instances of this class use {@link StreamsBuilder}.
 * @see StreamsBuilder
 *
 */
public interface Streams
    extends
    ChildOf<Restconf>,
    Augmentable<Streams>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("streams");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Streams> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Streams.class;
    }
    
    /**
     * Each entry describes an event stream supported by the server.
     *
     *
     *
     * @return <code>java.util.List</code> <code>stream</code>, or <code>null</code> if not present
     */
    @Nullable List<Stream> getStream();
    
    /**
     * @return <code>java.util.List</code> <code>stream</code>, or an empty list if it is not present
     */
    default @NonNull List<Stream> nonnullStream() {
        return CodeHelpers.nonnull(getStream());
    }

}

