package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.modules;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.RevisionIdentifier;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Modules;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.YangIdentifier;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Each entry represents one module currently supported by the server.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-restconf</b>
 * <pre>
 * list module {
 *   key "name revision";
 *   leaf name {
 *     type yang:yang-identifier;
 *   }
 *   leaf revision {
 *     type union {
 *       type revision-identifier;
 *       type string {
 *         length 0;
 *       }
 *     }
 *   }
 *   leaf namespace {
 *     type inet:uri;
 *   }
 *   leaf-list feature {
 *     type yang:yang-identifier;
 *   }
 *   leaf-list deviation {
 *     type yang:yang-identifier;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-restconf/restconf/restconf/modules/module</i>
 *
 * <p>To create instances of this class use {@link ModuleBuilder}.
 * @see ModuleBuilder
 * @see ModuleKey
 *
 */
public interface Module
    extends
    ChildOf<Modules>,
    Augmentable<Module>,
    Identifiable<ModuleKey>
{

    public static final class Revision
     implements TypeObject {
        private final RevisionIdentifier _revisionIdentifier;
        private final String _string;
    
    
        public Revision(RevisionIdentifier _revisionIdentifier) {
            super();
            this._revisionIdentifier = _revisionIdentifier;
            this._string = null;
        }
        
        private static void check_stringLength(final String value) {
            final int length = value.length();
            if (length == 0) {
                return;
            }
            CodeHelpers.throwInvalidLength("[[0..0]]", value);
        }
        public Revision(String _string) {
            super();
            check_stringLength(_string);
            
            this._string = _string;
            this._revisionIdentifier = null;
        }
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public Revision(Revision source) {
            this._revisionIdentifier = source._revisionIdentifier;
            this._string = source._string;
        }
        
        /**
         * Return a String representing the value of this union.
         *
         * @return String representation of this union's value.
         */
        public String stringValue() {
            if (_revisionIdentifier != null) {
                return _revisionIdentifier.getValue().toString();
            }
            if (_string != null) {
                return _string;
            }
        
            throw new IllegalStateException("No value assinged");
        }
    
    
        public RevisionIdentifier getRevisionIdentifier() {
            return _revisionIdentifier;
        }
        
        public String getString() {
            return _string;
        }
    
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_revisionIdentifier);
            result = prime * result + Objects.hashCode(_string);
            return result;
        }
    
        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (getClass() != obj.getClass()) {
                return false;
            }
            Revision other = (Revision) obj;
            if (!Objects.equals(_revisionIdentifier, other._revisionIdentifier)) {
                return false;
            }
            if (!Objects.equals(_string, other._string)) {
                return false;
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Revision.class);
            CodeHelpers.appendValue(helper, "_revisionIdentifier", _revisionIdentifier);
            CodeHelpers.appendValue(helper, "_string", _string);
            return helper.toString();
        }
    }
    


    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("module");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.modules.Module> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.modules.Module.class;
    }
    
    /**
     * The YANG module name.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.YangIdentifier</code> <code>name</code>, or <code>null</code> if not present
     */
    @Nullable YangIdentifier getName();
    
    /**
     * The YANG module revision date. An empty string is used if no revision statement
     * is present in the YANG module.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.modules.Module.Revision</code> <code>revision</code>, or <code>null</code> if not present
     */
    @Nullable Revision getRevision();
    
    /**
     * The XML namespace identifier for this module.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri</code> <code>namespace</code>, or <code>null</code> if not present
     */
    @Nullable Uri getNamespace();
    
    /**
     * List of YANG feature names from this module that are supported by the server.
     *
     *
     *
     * @return <code>java.util.List</code> <code>feature</code>, or <code>null</code> if not present
     */
    @Nullable List<YangIdentifier> getFeature();
    
    /**
     * List of YANG deviation module names used by this server to modify the
     * conformance of the module associated with this entry.
     *
     *
     *
     * @return <code>java.util.List</code> <code>deviation</code>, or <code>null</code> if not present
     */
    @Nullable List<YangIdentifier> getDeviation();
    
    @Override
    ModuleKey key();

}

