package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.modules;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.YangIdentifier;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

public class ModuleKey
 implements Identifier<Module> {
    private static final long serialVersionUID = 9146074411888999847L;
    private final YangIdentifier _name;
    private final Module.Revision _revision;


    public ModuleKey(YangIdentifier _name, Module.Revision _revision) {
    
    
        this._name = _name;
        this._revision = _revision;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public ModuleKey(ModuleKey source) {
        this._name = source._name;
        this._revision = source._revision;
    }


    public YangIdentifier getName() {
        return _name;
    }
    
    public Module.Revision getRevision() {
        return _revision;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_name);
        result = prime * result + Objects.hashCode(_revision);
        return result;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        ModuleKey other = (ModuleKey) obj;
        if (!Objects.equals(_name, other._name)) {
            return false;
        }
        if (!Objects.equals(_revision, other._revision)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(ModuleKey.class);
        CodeHelpers.appendValue(helper, "_name", _name);
        CodeHelpers.appendValue(helper, "_revision", _revision);
        return helper.toString();
    }
}

