package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.streams;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.Streams;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Each entry describes an event stream supported by the server.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-restconf</b>
 * <pre>
 * list stream {
 *   key name;
 *   leaf name {
 *     type string;
 *   }
 *   leaf description {
 *     type string;
 *   }
 *   leaf replay-support {
 *     type boolean;
 *   }
 *   leaf replay-log-creation-time {
 *     type yang:date-and-time;
 *   }
 *   leaf events {
 *     type empty;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-restconf/restconf/restconf/streams/stream</i>
 *
 * <p>To create instances of this class use {@link StreamBuilder}.
 * @see StreamBuilder
 * @see StreamKey
 *
 */
public interface Stream
    extends
    ChildOf<Streams>,
    Augmentable<Stream>,
    Identifiable<StreamKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("stream");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.streams.Stream> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.streams.Stream.class;
    }
    
    /**
     * The stream name
     *
     *
     *
     * @return <code>java.lang.String</code> <code>name</code>, or <code>null</code> if not present
     */
    @Nullable String getName();
    
    /**
     * Description of stream content
     *
     *
     *
     * @return <code>java.lang.String</code> <code>description</code>, or <code>null</code> if not present
     */
    @Nullable String getDescription();
    
    /**
     * Indicates if replay buffer supported for this stream
     *
     *
     *
     * @return <code>java.lang.Boolean</code> <code>replaySupport</code>, or <code>null</code> if not present
     */
    @Nullable Boolean isReplaySupport();
    
    /**
     * Indicates the time the replay log for this stream was created.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime</code> <code>replayLogCreationTime</code>, or <code>null</code> if not present
     */
    @Nullable DateAndTime getReplayLogCreationTime();
    
    /**
     * Represents the entry point for establishing notification delivery via server
     * sent events.
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Empty</code> <code>events</code>, or <code>null</code> if not present
     */
    @Nullable Empty getEvents();
    
    @Override
    StreamKey key();

}

