package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.yang.patch.Edit;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Represents a conceptual sequence of datastore edits, called a patch. Each patch 
 * is given a client-assigned patch identifier. Each edit MUST be applied in 
 * ascending order, and all edits MUST be applied. If any errors occur, then the 
 * target datastore MUST NOT be changed by the patch operation. A patch MUST be 
 * validated by the server to be a well-formed message before any of the patch 
 * edits are validated or attempted. YANG datastore validation (defined in RFC 
 * 6020, section 8.3.3) is performed after all edits have been individually 
 * validated. It is possible for a datastore constraint violation to occur due to 
 * any node in the datastore, including nodes not included in the edit list. Any 
 * validation errors MUST be reported in the reply message.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-restconf</b>
 * <pre>
 * container yang-patch {
 *   leaf patch-id {
 *     type string;
 *   }
 *   leaf comment {
 *     type string {
 *       length "0 .. 1024";
 *     }
 *   }
 *   list edit {
 *     key edit-id;
 *     ordered-by user;
 *     leaf edit-id {
 *       type string;
 *     }
 *     leaf operation {
 *       type enumeration {
 *         enum create {
 *         }
 *         enum delete {
 *         }
 *         enum insert {
 *         }
 *         enum merge {
 *         }
 *         enum move {
 *         }
 *         enum replace {
 *         }
 *         enum remove {
 *         }
 *       }
 *     }
 *     leaf target {
 *       type data-resource-identifier;
 *     }
 *     leaf point {
 *       when "(../operation = 'insert' or ../operation = 'move') and (../where = 'before' or ../where = 'after')" {
 *       }
 *       type data-resource-identifier;
 *     }
 *     leaf where {
 *       when "../operation = 'insert' or ../operation = 'move'" {
 *       }
 *       type enumeration {
 *         enum before {
 *         }
 *         enum after {
 *         }
 *         enum first {
 *         }
 *         enum last {
 *         }
 *       }
 *       default last;
 *     }
 *     anyxml value {
 *       when "(../operation = 'create' or ../operation = 'merge' or ../operation = 'replace' or ../operation = 'insert')" {
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-restconf/yang-patch/yang-patch</i>
 *
 * <p>To create instances of this class use {@link YangPatchBuilder}.
 * @see YangPatchBuilder
 *
 */
public interface YangPatch
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.YangPatch>,
    Augmentable<YangPatch>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("yang-patch");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.YangPatch> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.YangPatch.class;
    }
    
    /**
     * An arbitrary string provided by the client to identify the entire patch. This
     * value SHOULD be present in any audit logging records generated by the server for
     * the patch. Error messages returned by the server pertaining to this patch will
     * be identified by this patch-id value.
     *
     *
     *
     * @return <code>java.lang.String</code> <code>patchId</code>, or <code>null</code> if not present
     */
    @Nullable String getPatchId();
    
    /**
     * An arbitrary string provided by the client to describe the entire patch. This
     * value SHOULD be present in any audit logging records generated by the server for
     * the patch.
     *
     *
     *
     * @return <code>java.lang.String</code> <code>comment</code>, or <code>null</code> if not present
     */
    @Nullable String getComment();
    
    /**
     * Represents one edit within the YANG Patch request message.
     *
     *
     *
     * @return <code>java.util.List</code> <code>edit</code>, or <code>null</code> if not present
     */
    @Nullable List<Edit> getEdit();
    
    /**
     * @return <code>java.util.List</code> <code>edit</code>, or an empty list if it is not present
     */
    default @NonNull List<Edit> nonnullEdit() {
        return CodeHelpers.nonnull(getEdit());
    }

}

