package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.status;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.status.yang.patch.status.EditStatus;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.status.yang.patch.status.GlobalStatus;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * A container representing the response message sent by the server after a YANG 
 * Patch edit request message has been processed.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-restconf</b>
 * <pre>
 * container yang-patch-status {
 *   leaf patch-id {
 *     type string;
 *   }
 *   choice global-status {
 *     case global-errors {
 *       uses errors;
 *     }
 *     case ok {
 *       leaf ok {
 *         type empty;
 *       }
 *     }
 *   }
 *   container edit-status {
 *     list edit {
 *       key edit-id;
 *       leaf edit-id {
 *         type string;
 *       }
 *       choice edit-status-choice {
 *         case ok {
 *           leaf ok {
 *             type empty;
 *           }
 *         }
 *         case location {
 *           leaf location {
 *             type inet:uri;
 *           }
 *         }
 *         case errors {
 *           uses errors;
 *         }
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-restconf/yang-patch-status/yang-patch-status</i>
 *
 * <p>To create instances of this class use {@link YangPatchStatusBuilder}.
 * @see YangPatchStatusBuilder
 *
 */
public interface YangPatchStatus
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.YangPatchStatus>,
    Augmentable<YangPatchStatus>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("yang-patch-status");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.status.YangPatchStatus> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.status.YangPatchStatus.class;
    }
    
    /**
     * The patch-id value used in the request
     *
     *
     *
     * @return <code>java.lang.String</code> <code>patchId</code>, or <code>null</code> if not present
     */
    @Nullable String getPatchId();
    
    /**
     * Report global errors or complete success. If there is no case selected then
     * errors are reported in the edit-status container.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.status.yang.patch.status.GlobalStatus</code> <code>globalStatus</code>, or <code>null</code> if not present
     */
    @Nullable GlobalStatus getGlobalStatus();
    
    /**
     * This container will be present if there are edit-specific status responses to
     * report.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.status.yang.patch.status.EditStatus</code> <code>editStatus</code>, or <code>null</code> if not present
     */
    @Nullable EditStatus getEditStatus();

}

