package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.status.yang.patch.status;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.status.YangPatchStatus;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.status.yang.patch.status.edit.status.Edit;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * This container will be present if there are edit-specific status responses to 
 * report.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-restconf</b>
 * <pre>
 * container edit-status {
 *   list edit {
 *     key edit-id;
 *     leaf edit-id {
 *       type string;
 *     }
 *     choice edit-status-choice {
 *       case ok {
 *         leaf ok {
 *           type empty;
 *         }
 *       }
 *       case location {
 *         leaf location {
 *           type inet:uri;
 *         }
 *       }
 *       case errors {
 *         uses errors;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-restconf/yang-patch-status/yang-patch-status/edit-status</i>
 *
 * <p>To create instances of this class use {@link EditStatusBuilder}.
 * @see EditStatusBuilder
 *
 */
public interface EditStatus
    extends
    ChildOf<YangPatchStatus>,
    Augmentable<EditStatus>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("edit-status");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.status.yang.patch.status.EditStatus> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.status.yang.patch.status.EditStatus.class;
    }
    
    /**
     * Represents a list of status responses, corresponding to edits in the YANG Patch
     * request message. If an edit entry was skipped or not reached by the server, then
     * this list will not contain a corresponding entry for that edit.
     *
     *
     *
     * @return <code>java.util.List</code> <code>edit</code>, or <code>null</code> if not present
     */
    @Nullable List<Edit> getEdit();
    
    /**
     * @return <code>java.util.List</code> <code>edit</code>, or an empty list if it is not present
     */
    default @NonNull List<Edit> nonnullEdit() {
        return CodeHelpers.nonnull(getEdit());
    }

}

