package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.status.yang.patch.status.edit.status;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.status.yang.patch.status.EditStatus;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.status.yang.patch.status.edit.status.edit.EditStatusChoice;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Represents a list of status responses, corresponding to edits in the YANG Patch 
 * request message. If an edit entry was skipped or not reached by the server, 
 * this list will not contain a corresponding entry for that edit.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-restconf</b>
 * <pre>
 * list edit {
 *   key edit-id;
 *   leaf edit-id {
 *     type string;
 *   }
 *   choice edit-status-choice {
 *     case ok {
 *       leaf ok {
 *         type empty;
 *       }
 *     }
 *     case location {
 *       leaf location {
 *         type inet:uri;
 *       }
 *     }
 *     case errors {
 *       uses errors;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-restconf/yang-patch-status/yang-patch-status/edit-status/edit</i>
 *
 * <p>To create instances of this class use {@link EditBuilder}.
 * @see EditBuilder
 * @see EditKey
 *
 */
public interface Edit
    extends
    ChildOf<EditStatus>,
    Augmentable<Edit>,
    Identifiable<EditKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("edit");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.status.yang.patch.status.edit.status.Edit> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.status.yang.patch.status.edit.status.Edit.class;
    }
    
    /**
     * Response status is for the edit list entry with this edit-id value.
     *
     *
     *
     * @return <code>java.lang.String</code> <code>editId</code>, or <code>null</code> if not present
     */
    @Nullable String getEditId();
    
    /**
     * A choice between different types of status responses for each edit entry.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.status.yang.patch.status.edit.status.edit.EditStatusChoice</code> <code>editStatusChoice</code>, or <code>null</code> if not present
     */
    @Nullable EditStatusChoice getEditStatusChoice();
    
    @Override
    EditKey key();

}

