package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.status.yang.patch.status.edit.status;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

public class EditKey
 implements Identifier<Edit> {
    private static final long serialVersionUID = -6519062221528580976L;
    private final String _editId;


    public EditKey(String _editId) {
    
    
        this._editId = _editId;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public EditKey(EditKey source) {
        this._editId = source._editId;
    }


    public String getEditId() {
        return _editId;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_editId);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        EditKey other = (EditKey) obj;
        if (!Objects.equals(_editId, other._editId)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(EditKey.class);
        CodeHelpers.appendValue(helper, "_editId", _editId);
        return helper.toString();
    }
}

