package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.yang.patch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.DataResourceIdentifier;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.YangPatch;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.yang.patch.edit.Value;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Represents one edit within the YANG Patch request message.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-restconf</b>
 * <pre>
 * list edit {
 *   key edit-id;
 *   ordered-by user;
 *   leaf edit-id {
 *     type string;
 *   }
 *   leaf operation {
 *     type enumeration {
 *       enum create {
 *       }
 *       enum delete {
 *       }
 *       enum insert {
 *       }
 *       enum merge {
 *       }
 *       enum move {
 *       }
 *       enum replace {
 *       }
 *       enum remove {
 *       }
 *     }
 *   }
 *   leaf target {
 *     type data-resource-identifier;
 *   }
 *   leaf point {
 *     when "(../operation = 'insert' or ../operation = 'move') and (../where = 'before' or ../where = 'after')" {
 *     }
 *     type data-resource-identifier;
 *   }
 *   leaf where {
 *     when "../operation = 'insert' or ../operation = 'move'" {
 *     }
 *     type enumeration {
 *       enum before {
 *       }
 *       enum after {
 *       }
 *       enum first {
 *       }
 *       enum last {
 *       }
 *     }
 *     default last;
 *   }
 *   anyxml value {
 *     when "(../operation = 'create' or ../operation = 'merge' or ../operation = 'replace' or ../operation = 'insert')" {
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-restconf/yang-patch/yang-patch/edit</i>
 *
 * <p>To create instances of this class use {@link EditBuilder}.
 * @see EditBuilder
 * @see EditKey
 *
 */
public interface Edit
    extends
    ChildOf<YangPatch>,
    Augmentable<Edit>,
    Identifiable<EditKey>
{


    public enum Operation implements Enumeration {
        /**
         * The target data node is created using the supplied value, only if it does not
         * already exist.
         *
         */
        Create(0, "create"),
        
        /**
         * Delete the target node, only if the data resource currently exists, otherwise
         * return an error.
         *
         */
        Delete(1, "delete"),
        
        /**
         * Insert the supplied value into a user-ordered list or leaf-list entry. The
         * target node must represent a new data resource.
         *
         */
        Insert(2, "insert"),
        
        /**
         * The supplied value is merged with the target data node.
         *
         */
        Merge(3, "merge"),
        
        /**
         * Move the target node. Reorder a user-ordered list or leaf-list. The target node
         * must represent an existing data resource.
         *
         */
        Move(4, "move"),
        
        /**
         * The supplied value is used to replace the target data node.
         *
         */
        Replace(5, "replace"),
        
        /**
         * Delete the target node if it currently exists.
         *
         */
        Remove(6, "remove")
        ;
    
        private static final Map<String, Operation> NAME_MAP;
        private static final Map<Integer, Operation> VALUE_MAP;
    
        static {
            final Builder<String, Operation> nb = ImmutableMap.builder();
            final Builder<Integer, Operation> vb = ImmutableMap.builder();
            for (Operation enumItem : Operation.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private Operation(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding Operation item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<Operation> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding Operation item, or null if no such item exists
         */
        public static Operation forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }
    
    public enum Where implements Enumeration {
        /**
         * Insert or move a data node before the data resource identified by the 'point'
         * parameter.
         *
         */
        Before(0, "before"),
        
        /**
         * Insert or move a data node after the data resource identified by the 'point'
         * parameter.
         *
         */
        After(1, "after"),
        
        /**
         * Insert or move a data node so it becomes ordered as the first entry.
         *
         */
        First(2, "first"),
        
        /**
         * Insert or move a data node so it becomes ordered as the last entry.
         *
         */
        Last(3, "last")
        ;
    
        private static final Map<String, Where> NAME_MAP;
        private static final Map<Integer, Where> VALUE_MAP;
    
        static {
            final Builder<String, Where> nb = ImmutableMap.builder();
            final Builder<Integer, Where> vb = ImmutableMap.builder();
            for (Where enumItem : Where.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private Where(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding Where item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<Where> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding Where item, or null if no such item exists
         */
        public static Where forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }

    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("edit");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.yang.patch.Edit> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.yang.patch.Edit.class;
    }
    
    /**
     * Arbitrary string index for the edit. Error messages returned by the server
     * pertaining to a specific edit will be identified by this value.
     *
     *
     *
     * @return <code>java.lang.String</code> <code>editId</code>, or <code>null</code> if not present
     */
    @Nullable String getEditId();
    
    /**
     * The datastore operation requested for the associated edit entry
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.yang.patch.Edit.Operation</code> <code>operation</code>, or <code>null</code> if not present
     */
    @Nullable Operation getOperation();
    
    /**
     * Identifies the target data resource for the edit operation.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.DataResourceIdentifier</code> <code>target</code>, or <code>null</code> if not present
     */
    @Nullable DataResourceIdentifier getTarget();
    
    /**
     * The absolute URL path for the data node that is being used as the insertion
     * point or move point for the target of this edit entry.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.DataResourceIdentifier</code> <code>point</code>, or <code>null</code> if not present
     */
    @Nullable DataResourceIdentifier getPoint();
    
    /**
     * Identifies where a data resource will be inserted or moved. YANG only allows
     * these operations for list and leaf-list data nodes that are ordered-by user.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.yang.patch.Edit.Where</code> <code>where</code>, or <code>null</code> if not present
     */
    @Nullable Where getWhere();
    
    /**
     * Value used for this edit operation.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.yang.patch.yang.patch.edit.Value</code> <code>value</code>, or <code>null</code> if not present
     */
    @Nullable Value getValue();
    
    @Override
    EditKey key();

}

