/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.modules;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.modules.Module;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev131019.restconf.restconf.modules.ModuleKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.YangIdentifier;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ModuleBuilder
implements Builder<Module> {
    private List<YangIdentifier> _deviation;
    private List<YangIdentifier> _feature;
    private YangIdentifier _name;
    private Uri _namespace;
    private Module.Revision _revision;
    private ModuleKey key;
    Map<Class<? extends Augmentation<Module>>, Augmentation<Module>> augmentation = Collections.emptyMap();

    public ModuleBuilder() {
    }

    public ModuleBuilder(Module base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Module>>, Augmentation<Module>>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._revision = base.getRevision();
        this._deviation = base.getDeviation();
        this._feature = base.getFeature();
        this._namespace = base.getNamespace();
    }

    public ModuleKey key() {
        return this.key;
    }

    public List<YangIdentifier> getDeviation() {
        return this._deviation;
    }

    public List<YangIdentifier> getFeature() {
        return this._feature;
    }

    public YangIdentifier getName() {
        return this._name;
    }

    public Uri getNamespace() {
        return this._namespace;
    }

    public Module.Revision getRevision() {
        return this._revision;
    }

    public <E$$ extends Augmentation<Module>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public ModuleBuilder withKey(ModuleKey key) {
        this.key = key;
        return this;
    }

    public ModuleBuilder setDeviation(List<YangIdentifier> values) {
        this._deviation = values;
        return this;
    }

    public ModuleBuilder setFeature(List<YangIdentifier> values) {
        this._feature = values;
        return this;
    }

    public ModuleBuilder setName(YangIdentifier value) {
        this._name = value;
        return this;
    }

    public ModuleBuilder setNamespace(Uri value) {
        this._namespace = value;
        return this;
    }

    public ModuleBuilder setRevision(Module.Revision value) {
        this._revision = value;
        return this;
    }

    public ModuleBuilder addAugmentation(Class<? extends Augmentation<Module>> augmentationType, Augmentation<Module> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Module>>, Augmentation<Module>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ModuleBuilder removeAugmentation(Class<? extends Augmentation<Module>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Module build() {
        return new ModuleImpl(this);
    }

    private static final class ModuleImpl
    extends AbstractAugmentable<Module>
    implements Module {
        private final List<YangIdentifier> _deviation;
        private final List<YangIdentifier> _feature;
        private final YangIdentifier _name;
        private final Uri _namespace;
        private final Module.Revision _revision;
        private final ModuleKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ModuleImpl(ModuleBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new ModuleKey(base.getName(), base.getRevision());
            this._name = this.key.getName();
            this._revision = this.key.getRevision();
            this._deviation = base.getDeviation();
            this._feature = base.getFeature();
            this._namespace = base.getNamespace();
        }

        @Override
        public ModuleKey key() {
            return this.key;
        }

        @Override
        public List<YangIdentifier> getDeviation() {
            return this._deviation;
        }

        @Override
        public List<YangIdentifier> getFeature() {
            return this._feature;
        }

        @Override
        public YangIdentifier getName() {
            return this._name;
        }

        @Override
        public Uri getNamespace() {
            return this._namespace;
        }

        @Override
        public Module.Revision getRevision() {
            return this._revision;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._deviation);
            result = 31 * result + Objects.hashCode(this._feature);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._namespace);
            result = 31 * result + Objects.hashCode(this._revision);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Module.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Module other = (Module)obj;
            if (!Objects.equals(this._deviation, other.getDeviation())) {
                return false;
            }
            if (!Objects.equals(this._feature, other.getFeature())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._namespace, other.getNamespace())) {
                return false;
            }
            if (!Objects.equals(this._revision, other.getRevision())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ModuleImpl otherImpl = (ModuleImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Module");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_deviation", this._deviation);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_feature", this._feature);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_name", (Object)this._name);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_namespace", (Object)this._namespace);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_revision", (Object)this._revision);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

