/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.igp.link.attributes;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.FlagIdentity;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.igp.link.attributes.IgpLinkAttributes;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class IgpLinkAttributesBuilder
implements Builder<IgpLinkAttributes> {
    private List<Class<? extends FlagIdentity>> _flag;
    private Uint32 _metric;
    private String _name;
    Map<Class<? extends Augmentation<IgpLinkAttributes>>, Augmentation<IgpLinkAttributes>> augmentation = Collections.emptyMap();

    public IgpLinkAttributesBuilder() {
    }

    public IgpLinkAttributesBuilder(IgpLinkAttributes base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IgpLinkAttributes>>, Augmentation<IgpLinkAttributes>>(aug);
        }
        this._flag = base.getFlag();
        this._metric = base.getMetric();
        this._name = base.getName();
    }

    public List<Class<? extends FlagIdentity>> getFlag() {
        return this._flag;
    }

    public Uint32 getMetric() {
        return this._metric;
    }

    public String getName() {
        return this._name;
    }

    public <E$$ extends Augmentation<IgpLinkAttributes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public IgpLinkAttributesBuilder setFlag(List<Class<? extends FlagIdentity>> values) {
        this._flag = values;
        return this;
    }

    private static void checkMetricRange(long value) {
        if (value <= 0xFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..16777215]]", (long)value);
    }

    public IgpLinkAttributesBuilder setMetric(Uint32 value) {
        if (value != null) {
            IgpLinkAttributesBuilder.checkMetricRange(value.longValue());
        }
        this._metric = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public IgpLinkAttributesBuilder setMetric(Long value) {
        return this.setMetric(CodeHelpers.compatUint((Long)value));
    }

    public IgpLinkAttributesBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public IgpLinkAttributesBuilder addAugmentation(Augmentation<IgpLinkAttributes> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public IgpLinkAttributesBuilder addAugmentation(Class<? extends Augmentation<IgpLinkAttributes>> augmentationType, Augmentation<IgpLinkAttributes> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public IgpLinkAttributesBuilder removeAugmentation(Class<? extends Augmentation<IgpLinkAttributes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private IgpLinkAttributesBuilder doAddAugmentation(Class<? extends Augmentation<IgpLinkAttributes>> augmentationType, Augmentation<IgpLinkAttributes> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IgpLinkAttributes>>, Augmentation<IgpLinkAttributes>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public IgpLinkAttributes build() {
        return new IgpLinkAttributesImpl(this);
    }

    private static final class IgpLinkAttributesImpl
    extends AbstractAugmentable<IgpLinkAttributes>
    implements IgpLinkAttributes {
        private final List<Class<? extends FlagIdentity>> _flag;
        private final Uint32 _metric;
        private final String _name;
        private int hash = 0;
        private volatile boolean hashValid = false;

        IgpLinkAttributesImpl(IgpLinkAttributesBuilder base) {
            super(base.augmentation);
            this._flag = base.getFlag();
            this._metric = base.getMetric();
            this._name = base.getName();
        }

        @Override
        public List<Class<? extends FlagIdentity>> getFlag() {
            return this._flag;
        }

        @Override
        public Uint32 getMetric() {
            return this._metric;
        }

        @Override
        public String getName() {
            return this._name;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._flag);
            result = 31 * result + Objects.hashCode(this._metric);
            result = 31 * result + Objects.hashCode(this._name);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!IgpLinkAttributes.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            IgpLinkAttributes other = (IgpLinkAttributes)obj;
            if (!Objects.equals(this._flag, other.getFlag())) {
                return false;
            }
            if (!Objects.equals(this._metric, other.getMetric())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                IgpLinkAttributesImpl otherImpl = (IgpLinkAttributesImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"IgpLinkAttributes");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_flag", this._flag);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_metric", (Object)this._metric);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_name", (Object)this._name);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

