/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.igp.node.attributes;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.DomainName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.FlagIdentity;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.igp.node.attributes.IgpNodeAttributes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.igp.node.attributes.igp.node.attributes.Prefix;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.igp.node.attributes.igp.node.attributes.PrefixKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class IgpNodeAttributesBuilder
implements Builder<IgpNodeAttributes> {
    private List<Class<? extends FlagIdentity>> _flag;
    private DomainName _name;
    private Map<PrefixKey, Prefix> _prefix;
    private List<IpAddress> _routerId;
    Map<Class<? extends Augmentation<IgpNodeAttributes>>, Augmentation<IgpNodeAttributes>> augmentation = Collections.emptyMap();

    public IgpNodeAttributesBuilder() {
    }

    public IgpNodeAttributesBuilder(IgpNodeAttributes base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IgpNodeAttributes>>, Augmentation<IgpNodeAttributes>>(aug);
        }
        this._flag = base.getFlag();
        this._name = base.getName();
        this._prefix = base.getPrefix();
        this._routerId = base.getRouterId();
    }

    public List<Class<? extends FlagIdentity>> getFlag() {
        return this._flag;
    }

    public DomainName getName() {
        return this._name;
    }

    public Map<PrefixKey, Prefix> getPrefix() {
        return this._prefix;
    }

    public List<IpAddress> getRouterId() {
        return this._routerId;
    }

    public <E$$ extends Augmentation<IgpNodeAttributes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public IgpNodeAttributesBuilder setFlag(List<Class<? extends FlagIdentity>> values) {
        this._flag = values;
        return this;
    }

    public IgpNodeAttributesBuilder setName(DomainName value) {
        this._name = value;
        return this;
    }

    public IgpNodeAttributesBuilder setPrefix(Map<PrefixKey, Prefix> values) {
        this._prefix = values;
        return this;
    }

    @Deprecated(forRemoval=true)
    public IgpNodeAttributesBuilder setPrefix(List<Prefix> values) {
        return this.setPrefix(CodeHelpers.compatMap(values));
    }

    public IgpNodeAttributesBuilder setRouterId(List<IpAddress> values) {
        this._routerId = values;
        return this;
    }

    public IgpNodeAttributesBuilder addAugmentation(Augmentation<IgpNodeAttributes> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public IgpNodeAttributesBuilder addAugmentation(Class<? extends Augmentation<IgpNodeAttributes>> augmentationType, Augmentation<IgpNodeAttributes> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public IgpNodeAttributesBuilder removeAugmentation(Class<? extends Augmentation<IgpNodeAttributes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private IgpNodeAttributesBuilder doAddAugmentation(Class<? extends Augmentation<IgpNodeAttributes>> augmentationType, Augmentation<IgpNodeAttributes> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IgpNodeAttributes>>, Augmentation<IgpNodeAttributes>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public IgpNodeAttributes build() {
        return new IgpNodeAttributesImpl(this);
    }

    private static final class IgpNodeAttributesImpl
    extends AbstractAugmentable<IgpNodeAttributes>
    implements IgpNodeAttributes {
        private final List<Class<? extends FlagIdentity>> _flag;
        private final DomainName _name;
        private final Map<PrefixKey, Prefix> _prefix;
        private final List<IpAddress> _routerId;
        private int hash = 0;
        private volatile boolean hashValid = false;

        IgpNodeAttributesImpl(IgpNodeAttributesBuilder base) {
            super(base.augmentation);
            this._flag = base.getFlag();
            this._name = base.getName();
            this._prefix = CodeHelpers.emptyToNull(base.getPrefix());
            this._routerId = base.getRouterId();
        }

        @Override
        public List<Class<? extends FlagIdentity>> getFlag() {
            return this._flag;
        }

        @Override
        public DomainName getName() {
            return this._name;
        }

        @Override
        public Map<PrefixKey, Prefix> getPrefix() {
            return this._prefix;
        }

        @Override
        public List<IpAddress> getRouterId() {
            return this._routerId;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._flag);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._prefix);
            result = 31 * result + Objects.hashCode(this._routerId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!IgpNodeAttributes.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            IgpNodeAttributes other = (IgpNodeAttributes)obj;
            if (!Objects.equals(this._flag, other.getFlag())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._prefix, other.getPrefix())) {
                return false;
            }
            if (!Objects.equals(this._routerId, other.getRouterId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                IgpNodeAttributesImpl otherImpl = (IgpNodeAttributesImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"IgpNodeAttributes");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_flag", this._flag);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_name", (Object)this._name);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_prefix", this._prefix);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_routerId", this._routerId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

