/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.igp.node.attributes.igp.node.attributes;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.FlagIdentity;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.IgpPrefixAttributes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.igp.node.attributes.igp.node.attributes.Prefix;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.igp.node.attributes.igp.node.attributes.PrefixKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class PrefixBuilder
implements Builder<Prefix> {
    private List<Class<? extends FlagIdentity>> _flag;
    private Uint32 _metric;
    private IpPrefix _prefix;
    private PrefixKey key;
    Map<Class<? extends Augmentation<Prefix>>, Augmentation<Prefix>> augmentation = Collections.emptyMap();

    public PrefixBuilder() {
    }

    public PrefixBuilder(IgpPrefixAttributes arg) {
        this._prefix = arg.getPrefix();
        this._metric = arg.getMetric();
        this._flag = arg.getFlag();
    }

    public PrefixBuilder(Prefix base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Prefix>>, Augmentation<Prefix>>(aug);
        }
        this.key = base.key();
        this._prefix = base.getPrefix();
        this._flag = base.getFlag();
        this._metric = base.getMetric();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof IgpPrefixAttributes) {
            this._prefix = ((IgpPrefixAttributes)arg).getPrefix();
            this._metric = ((IgpPrefixAttributes)arg).getMetric();
            this._flag = ((IgpPrefixAttributes)arg).getFlag();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.IgpPrefixAttributes]");
    }

    public PrefixKey key() {
        return this.key;
    }

    public List<Class<? extends FlagIdentity>> getFlag() {
        return this._flag;
    }

    public Uint32 getMetric() {
        return this._metric;
    }

    public IpPrefix getPrefix() {
        return this._prefix;
    }

    public <E$$ extends Augmentation<Prefix>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public PrefixBuilder withKey(PrefixKey key) {
        this.key = key;
        return this;
    }

    public PrefixBuilder setFlag(List<Class<? extends FlagIdentity>> values) {
        this._flag = values;
        return this;
    }

    public PrefixBuilder setMetric(Uint32 value) {
        this._metric = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public PrefixBuilder setMetric(Long value) {
        return this.setMetric(CodeHelpers.compatUint((Long)value));
    }

    public PrefixBuilder setPrefix(IpPrefix value) {
        this._prefix = value;
        return this;
    }

    public PrefixBuilder addAugmentation(Augmentation<Prefix> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public PrefixBuilder addAugmentation(Class<? extends Augmentation<Prefix>> augmentationType, Augmentation<Prefix> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public PrefixBuilder removeAugmentation(Class<? extends Augmentation<Prefix>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private PrefixBuilder doAddAugmentation(Class<? extends Augmentation<Prefix>> augmentationType, Augmentation<Prefix> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Prefix>>, Augmentation<Prefix>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public Prefix build() {
        return new PrefixImpl(this);
    }

    private static final class PrefixImpl
    extends AbstractAugmentable<Prefix>
    implements Prefix {
        private final List<Class<? extends FlagIdentity>> _flag;
        private final Uint32 _metric;
        private final IpPrefix _prefix;
        private final PrefixKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PrefixImpl(PrefixBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new PrefixKey(base.getPrefix());
            this._prefix = this.key.getPrefix();
            this._flag = base.getFlag();
            this._metric = base.getMetric();
        }

        @Override
        public PrefixKey key() {
            return this.key;
        }

        @Override
        public List<Class<? extends FlagIdentity>> getFlag() {
            return this._flag;
        }

        @Override
        public Uint32 getMetric() {
            return this._metric;
        }

        @Override
        public IpPrefix getPrefix() {
            return this._prefix;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._flag);
            result = 31 * result + Objects.hashCode(this._metric);
            result = 31 * result + Objects.hashCode(this._prefix);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Prefix.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Prefix other = (Prefix)obj;
            if (!Objects.equals(this._flag, other.getFlag())) {
                return false;
            }
            if (!Objects.equals(this._metric, other.getMetric())) {
                return false;
            }
            if (!Objects.equals(this._prefix, other.getPrefix())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PrefixImpl otherImpl = (PrefixImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Prefix");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_flag", this._flag);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_metric", (Object)this._metric);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_prefix", (Object)this._prefix);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

