/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.ospf.topology.rev131021.ospf.link.attributes;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.ospf.topology.rev131021.ospf.link.attributes.OspfLinkAttributes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.ospf.topology.rev131021.ospf.link.attributes.ospf.link.attributes.Ted;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

public class OspfLinkAttributesBuilder
implements Builder<OspfLinkAttributes> {
    private Uint8 _multiTopologyId;
    private Ted _ted;
    Map<Class<? extends Augmentation<OspfLinkAttributes>>, Augmentation<OspfLinkAttributes>> augmentation = Collections.emptyMap();

    public OspfLinkAttributesBuilder() {
    }

    public OspfLinkAttributesBuilder(OspfLinkAttributes base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OspfLinkAttributes>>, Augmentation<OspfLinkAttributes>>(aug);
        }
        this._multiTopologyId = base.getMultiTopologyId();
        this._ted = base.getTed();
    }

    public Uint8 getMultiTopologyId() {
        return this._multiTopologyId;
    }

    public Ted getTed() {
        return this._ted;
    }

    public <E$$ extends Augmentation<OspfLinkAttributes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    private static void checkMultiTopologyIdRange(short value) {
        if (value <= 127) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..127]]", (int)value);
    }

    public OspfLinkAttributesBuilder setMultiTopologyId(Uint8 value) {
        if (value != null) {
            OspfLinkAttributesBuilder.checkMultiTopologyIdRange(value.shortValue());
        }
        this._multiTopologyId = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public OspfLinkAttributesBuilder setMultiTopologyId(Short value) {
        return this.setMultiTopologyId(CodeHelpers.compatUint((Short)value));
    }

    public OspfLinkAttributesBuilder setTed(Ted value) {
        this._ted = value;
        return this;
    }

    public OspfLinkAttributesBuilder addAugmentation(Augmentation<OspfLinkAttributes> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public OspfLinkAttributesBuilder addAugmentation(Class<? extends Augmentation<OspfLinkAttributes>> augmentationType, Augmentation<OspfLinkAttributes> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public OspfLinkAttributesBuilder removeAugmentation(Class<? extends Augmentation<OspfLinkAttributes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private OspfLinkAttributesBuilder doAddAugmentation(Class<? extends Augmentation<OspfLinkAttributes>> augmentationType, Augmentation<OspfLinkAttributes> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OspfLinkAttributes>>, Augmentation<OspfLinkAttributes>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public OspfLinkAttributes build() {
        return new OspfLinkAttributesImpl(this);
    }

    private static final class OspfLinkAttributesImpl
    extends AbstractAugmentable<OspfLinkAttributes>
    implements OspfLinkAttributes {
        private final Uint8 _multiTopologyId;
        private final Ted _ted;
        private int hash = 0;
        private volatile boolean hashValid = false;

        OspfLinkAttributesImpl(OspfLinkAttributesBuilder base) {
            super(base.augmentation);
            this._multiTopologyId = base.getMultiTopologyId();
            this._ted = base.getTed();
        }

        @Override
        public Uint8 getMultiTopologyId() {
            return this._multiTopologyId;
        }

        @Override
        public Ted getTed() {
            return this._ted;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._multiTopologyId);
            result = 31 * result + Objects.hashCode(this._ted);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OspfLinkAttributes.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            OspfLinkAttributes other = (OspfLinkAttributes)obj;
            if (!Objects.equals(this._multiTopologyId, other.getMultiTopologyId())) {
                return false;
            }
            if (!Objects.equals(this._ted, other.getTed())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OspfLinkAttributesImpl otherImpl = (OspfLinkAttributesImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"OspfLinkAttributes");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_multiTopologyId", (Object)this._multiTopologyId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ted", (Object)this._ted);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

