/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.ospf.topology.rev131021.ospf.link.attributes.ospf.link.attributes;

import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.TedLinkAttributes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.ted.link.attributes.Srlg;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.ted.link.attributes.UnreservedBandwidth;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.ted.link.attributes.UnreservedBandwidthKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.ospf.topology.rev131021.ospf.link.attributes.ospf.link.attributes.Ted;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class TedBuilder
implements Builder<Ted> {
    private Uint32 _color;
    private BigDecimal _maxLinkBandwidth;
    private BigDecimal _maxResvLinkBandwidth;
    private Srlg _srlg;
    private Uint32 _teDefaultMetric;
    private Map<UnreservedBandwidthKey, UnreservedBandwidth> _unreservedBandwidth;
    Map<Class<? extends Augmentation<Ted>>, Augmentation<Ted>> augmentation = Collections.emptyMap();

    public TedBuilder() {
    }

    public TedBuilder(TedLinkAttributes arg) {
        this._color = arg.getColor();
        this._maxLinkBandwidth = arg.getMaxLinkBandwidth();
        this._maxResvLinkBandwidth = arg.getMaxResvLinkBandwidth();
        this._unreservedBandwidth = arg.getUnreservedBandwidth();
        this._teDefaultMetric = arg.getTeDefaultMetric();
        this._srlg = arg.getSrlg();
    }

    public TedBuilder(Ted base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ted>>, Augmentation<Ted>>(aug);
        }
        this._color = base.getColor();
        this._maxLinkBandwidth = base.getMaxLinkBandwidth();
        this._maxResvLinkBandwidth = base.getMaxResvLinkBandwidth();
        this._srlg = base.getSrlg();
        this._teDefaultMetric = base.getTeDefaultMetric();
        this._unreservedBandwidth = base.getUnreservedBandwidth();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TedLinkAttributes) {
            this._color = ((TedLinkAttributes)arg).getColor();
            this._maxLinkBandwidth = ((TedLinkAttributes)arg).getMaxLinkBandwidth();
            this._maxResvLinkBandwidth = ((TedLinkAttributes)arg).getMaxResvLinkBandwidth();
            this._unreservedBandwidth = ((TedLinkAttributes)arg).getUnreservedBandwidth();
            this._teDefaultMetric = ((TedLinkAttributes)arg).getTeDefaultMetric();
            this._srlg = ((TedLinkAttributes)arg).getSrlg();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.TedLinkAttributes]");
    }

    public Uint32 getColor() {
        return this._color;
    }

    public BigDecimal getMaxLinkBandwidth() {
        return this._maxLinkBandwidth;
    }

    public BigDecimal getMaxResvLinkBandwidth() {
        return this._maxResvLinkBandwidth;
    }

    public Srlg getSrlg() {
        return this._srlg;
    }

    public Uint32 getTeDefaultMetric() {
        return this._teDefaultMetric;
    }

    public Map<UnreservedBandwidthKey, UnreservedBandwidth> getUnreservedBandwidth() {
        return this._unreservedBandwidth;
    }

    public <E$$ extends Augmentation<Ted>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public TedBuilder setColor(Uint32 value) {
        this._color = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public TedBuilder setColor(Long value) {
        return this.setColor(CodeHelpers.compatUint((Long)value));
    }

    public TedBuilder setMaxLinkBandwidth(BigDecimal value) {
        if (value != null) {
            // empty if block
        }
        this._maxLinkBandwidth = value;
        return this;
    }

    public TedBuilder setMaxResvLinkBandwidth(BigDecimal value) {
        if (value != null) {
            // empty if block
        }
        this._maxResvLinkBandwidth = value;
        return this;
    }

    public TedBuilder setSrlg(Srlg value) {
        this._srlg = value;
        return this;
    }

    public TedBuilder setTeDefaultMetric(Uint32 value) {
        this._teDefaultMetric = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public TedBuilder setTeDefaultMetric(Long value) {
        return this.setTeDefaultMetric(CodeHelpers.compatUint((Long)value));
    }

    public TedBuilder setUnreservedBandwidth(Map<UnreservedBandwidthKey, UnreservedBandwidth> values) {
        this._unreservedBandwidth = values;
        return this;
    }

    @Deprecated(forRemoval=true)
    public TedBuilder setUnreservedBandwidth(List<UnreservedBandwidth> values) {
        return this.setUnreservedBandwidth(CodeHelpers.compatMap(values));
    }

    public TedBuilder addAugmentation(Augmentation<Ted> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public TedBuilder addAugmentation(Class<? extends Augmentation<Ted>> augmentationType, Augmentation<Ted> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public TedBuilder removeAugmentation(Class<? extends Augmentation<Ted>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private TedBuilder doAddAugmentation(Class<? extends Augmentation<Ted>> augmentationType, Augmentation<Ted> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ted>>, Augmentation<Ted>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public Ted build() {
        return new TedImpl(this);
    }

    private static final class TedImpl
    extends AbstractAugmentable<Ted>
    implements Ted {
        private final Uint32 _color;
        private final BigDecimal _maxLinkBandwidth;
        private final BigDecimal _maxResvLinkBandwidth;
        private final Srlg _srlg;
        private final Uint32 _teDefaultMetric;
        private final Map<UnreservedBandwidthKey, UnreservedBandwidth> _unreservedBandwidth;
        private int hash = 0;
        private volatile boolean hashValid = false;

        TedImpl(TedBuilder base) {
            super(base.augmentation);
            this._color = base.getColor();
            this._maxLinkBandwidth = base.getMaxLinkBandwidth();
            this._maxResvLinkBandwidth = base.getMaxResvLinkBandwidth();
            this._srlg = base.getSrlg();
            this._teDefaultMetric = base.getTeDefaultMetric();
            this._unreservedBandwidth = CodeHelpers.emptyToNull(base.getUnreservedBandwidth());
        }

        public Uint32 getColor() {
            return this._color;
        }

        public BigDecimal getMaxLinkBandwidth() {
            return this._maxLinkBandwidth;
        }

        public BigDecimal getMaxResvLinkBandwidth() {
            return this._maxResvLinkBandwidth;
        }

        public Srlg getSrlg() {
            return this._srlg;
        }

        public Uint32 getTeDefaultMetric() {
            return this._teDefaultMetric;
        }

        public Map<UnreservedBandwidthKey, UnreservedBandwidth> getUnreservedBandwidth() {
            return this._unreservedBandwidth;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._color);
            result = 31 * result + Objects.hashCode(this._maxLinkBandwidth);
            result = 31 * result + Objects.hashCode(this._maxResvLinkBandwidth);
            result = 31 * result + Objects.hashCode(this._srlg);
            result = 31 * result + Objects.hashCode(this._teDefaultMetric);
            result = 31 * result + Objects.hashCode(this._unreservedBandwidth);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Ted.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Ted other = (Ted)obj;
            if (!Objects.equals(this._color, other.getColor())) {
                return false;
            }
            if (!Objects.equals(this._maxLinkBandwidth, other.getMaxLinkBandwidth())) {
                return false;
            }
            if (!Objects.equals(this._maxResvLinkBandwidth, other.getMaxResvLinkBandwidth())) {
                return false;
            }
            if (!Objects.equals(this._srlg, other.getSrlg())) {
                return false;
            }
            if (!Objects.equals(this._teDefaultMetric, other.getTeDefaultMetric())) {
                return false;
            }
            if (!Objects.equals(this._unreservedBandwidth, other.getUnreservedBandwidth())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TedImpl otherImpl = (TedImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Ted");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_color", (Object)this._color);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_maxLinkBandwidth", (Object)this._maxLinkBandwidth);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_maxResvLinkBandwidth", (Object)this._maxResvLinkBandwidth);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_srlg", (Object)this._srlg);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_teDefaultMetric", (Object)this._teDefaultMetric);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_unreservedBandwidth", this._unreservedBandwidth);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

