/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.ospf.topology.rev131021.ospf.node.attributes;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.ospf.topology.rev131021.ospf.node.attributes.OspfNodeAttributes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.ospf.topology.rev131021.ospf.node.attributes.ospf.node.attributes.RouterType;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.ospf.topology.rev131021.ospf.node.attributes.ospf.node.attributes.Ted;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint8;

public class OspfNodeAttributesBuilder
implements Builder<OspfNodeAttributes> {
    private OspfNodeAttributes.Capabilities _capabilities;
    private Uint32 _drInterfaceId;
    private List<Uint8> _multiTopologyId;
    private RouterType _routerType;
    private Ted _ted;
    Map<Class<? extends Augmentation<OspfNodeAttributes>>, Augmentation<OspfNodeAttributes>> augmentation = Collections.emptyMap();

    public OspfNodeAttributesBuilder() {
    }

    public OspfNodeAttributesBuilder(OspfNodeAttributes base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OspfNodeAttributes>>, Augmentation<OspfNodeAttributes>>(aug);
        }
        this._capabilities = base.getCapabilities();
        this._drInterfaceId = base.getDrInterfaceId();
        this._multiTopologyId = base.getMultiTopologyId();
        this._routerType = base.getRouterType();
        this._ted = base.getTed();
    }

    public OspfNodeAttributes.Capabilities getCapabilities() {
        return this._capabilities;
    }

    public Uint32 getDrInterfaceId() {
        return this._drInterfaceId;
    }

    public List<Uint8> getMultiTopologyId() {
        return this._multiTopologyId;
    }

    public RouterType getRouterType() {
        return this._routerType;
    }

    public Ted getTed() {
        return this._ted;
    }

    public <E$$ extends Augmentation<OspfNodeAttributes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public OspfNodeAttributesBuilder setCapabilities(OspfNodeAttributes.Capabilities value) {
        this._capabilities = value;
        return this;
    }

    public OspfNodeAttributesBuilder setDrInterfaceId(Uint32 value) {
        this._drInterfaceId = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public OspfNodeAttributesBuilder setDrInterfaceId(Long value) {
        return this.setDrInterfaceId(CodeHelpers.compatUint((Long)value));
    }

    private static void checkMultiTopologyIdRange(short value) {
        if (value <= 127) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..127]]", (int)value);
    }

    public OspfNodeAttributesBuilder setMultiTopologyId(List<Uint8> values) {
        if (values != null) {
            for (Uint8 value : values) {
                OspfNodeAttributesBuilder.checkMultiTopologyIdRange(value.shortValue());
            }
        }
        this._multiTopologyId = values;
        return this;
    }

    public OspfNodeAttributesBuilder setRouterType(RouterType value) {
        this._routerType = value;
        return this;
    }

    public OspfNodeAttributesBuilder setTed(Ted value) {
        this._ted = value;
        return this;
    }

    public OspfNodeAttributesBuilder addAugmentation(Augmentation<OspfNodeAttributes> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public OspfNodeAttributesBuilder addAugmentation(Class<? extends Augmentation<OspfNodeAttributes>> augmentationType, Augmentation<OspfNodeAttributes> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public OspfNodeAttributesBuilder removeAugmentation(Class<? extends Augmentation<OspfNodeAttributes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private OspfNodeAttributesBuilder doAddAugmentation(Class<? extends Augmentation<OspfNodeAttributes>> augmentationType, Augmentation<OspfNodeAttributes> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OspfNodeAttributes>>, Augmentation<OspfNodeAttributes>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public OspfNodeAttributes build() {
        return new OspfNodeAttributesImpl(this);
    }

    private static final class OspfNodeAttributesImpl
    extends AbstractAugmentable<OspfNodeAttributes>
    implements OspfNodeAttributes {
        private final OspfNodeAttributes.Capabilities _capabilities;
        private final Uint32 _drInterfaceId;
        private final List<Uint8> _multiTopologyId;
        private final RouterType _routerType;
        private final Ted _ted;
        private int hash = 0;
        private volatile boolean hashValid = false;

        OspfNodeAttributesImpl(OspfNodeAttributesBuilder base) {
            super(base.augmentation);
            this._capabilities = base.getCapabilities();
            this._drInterfaceId = base.getDrInterfaceId();
            this._multiTopologyId = base.getMultiTopologyId();
            this._routerType = base.getRouterType();
            this._ted = base.getTed();
        }

        @Override
        public OspfNodeAttributes.Capabilities getCapabilities() {
            return this._capabilities;
        }

        @Override
        public Uint32 getDrInterfaceId() {
            return this._drInterfaceId;
        }

        @Override
        public List<Uint8> getMultiTopologyId() {
            return this._multiTopologyId;
        }

        @Override
        public RouterType getRouterType() {
            return this._routerType;
        }

        @Override
        public Ted getTed() {
            return this._ted;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._capabilities);
            result = 31 * result + Objects.hashCode(this._drInterfaceId);
            result = 31 * result + Objects.hashCode(this._multiTopologyId);
            result = 31 * result + Objects.hashCode(this._routerType);
            result = 31 * result + Objects.hashCode(this._ted);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OspfNodeAttributes.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            OspfNodeAttributes other = (OspfNodeAttributes)obj;
            if (!Objects.equals(this._capabilities, other.getCapabilities())) {
                return false;
            }
            if (!Objects.equals(this._drInterfaceId, other.getDrInterfaceId())) {
                return false;
            }
            if (!Objects.equals(this._multiTopologyId, other.getMultiTopologyId())) {
                return false;
            }
            if (!Objects.equals(this._routerType, other.getRouterType())) {
                return false;
            }
            if (!Objects.equals(this._ted, other.getTed())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OspfNodeAttributesImpl otherImpl = (OspfNodeAttributesImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"OspfNodeAttributes");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_capabilities", (Object)this._capabilities);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_drInterfaceId", (Object)this._drInterfaceId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_multiTopologyId", this._multiTopologyId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_routerType", (Object)this._routerType);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ted", (Object)this._ted);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

