/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.LinkKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.TopologyTypes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.TopologyTypesBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.UnderlayTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.UnderlayTopologyKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

public class TopologyBuilder {
    private Map<LinkKey, Link> _link;
    private Map<NodeKey, Node> _node;
    private Boolean _serverProvided;
    private TopologyId _topologyId;
    private TopologyTypes _topologyTypes;
    private Map<UnderlayTopologyKey, UnderlayTopology> _underlayTopology;
    private TopologyKey key;
    Map<Class<? extends Augmentation<Topology>>, Augmentation<Topology>> augmentation = Map.of();

    public TopologyBuilder() {
    }

    public TopologyBuilder(Topology base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Topology>>, Augmentation<Topology>>(aug);
        }
        this.key = base.key();
        this._topologyId = base.getTopologyId();
        this._link = base.getLink();
        this._node = base.getNode();
        this._serverProvided = base.getServerProvided();
        this._topologyTypes = base.getTopologyTypes();
        this._underlayTopology = base.getUnderlayTopology();
    }

    public TopologyKey key() {
        return this.key;
    }

    public Map<LinkKey, Link> getLink() {
        return this._link;
    }

    public Map<NodeKey, Node> getNode() {
        return this._node;
    }

    public Boolean getServerProvided() {
        return this._serverProvided;
    }

    public TopologyId getTopologyId() {
        return this._topologyId;
    }

    public TopologyTypes getTopologyTypes() {
        return this._topologyTypes;
    }

    public Map<UnderlayTopologyKey, UnderlayTopology> getUnderlayTopology() {
        return this._underlayTopology;
    }

    public <E$$ extends Augmentation<Topology>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public TopologyBuilder withKey(TopologyKey key) {
        this.key = key;
        return this;
    }

    public TopologyBuilder setLink(Map<LinkKey, Link> values) {
        this._link = values;
        return this;
    }

    public TopologyBuilder setNode(Map<NodeKey, Node> values) {
        this._node = values;
        return this;
    }

    public TopologyBuilder setServerProvided(Boolean value) {
        this._serverProvided = value;
        return this;
    }

    public TopologyBuilder setTopologyId(TopologyId value) {
        this._topologyId = value;
        return this;
    }

    public TopologyBuilder setTopologyTypes(TopologyTypes value) {
        this._topologyTypes = value;
        return this;
    }

    public TopologyBuilder setUnderlayTopology(Map<UnderlayTopologyKey, UnderlayTopology> values) {
        this._underlayTopology = values;
        return this;
    }

    public TopologyBuilder addAugmentation(Augmentation<Topology> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Topology>>, Augmentation<Topology>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public TopologyBuilder removeAugmentation(Class<? extends Augmentation<Topology>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Topology build() {
        return new TopologyImpl(this);
    }

    private static final class TopologyImpl
    extends AbstractAugmentable<Topology>
    implements Topology {
        private final Map<LinkKey, Link> _link;
        private final Map<NodeKey, Node> _node;
        private final Boolean _serverProvided;
        private final TopologyId _topologyId;
        private final TopologyTypes _topologyTypes;
        private final Map<UnderlayTopologyKey, UnderlayTopology> _underlayTopology;
        private final TopologyKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        TopologyImpl(TopologyBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new TopologyKey(base.getTopologyId());
            this._topologyId = this.key.getTopologyId();
            this._link = CodeHelpers.emptyToNull(base.getLink());
            this._node = CodeHelpers.emptyToNull(base.getNode());
            this._serverProvided = base.getServerProvided();
            this._topologyTypes = base.getTopologyTypes();
            this._underlayTopology = CodeHelpers.emptyToNull(base.getUnderlayTopology());
        }

        @Override
        public TopologyKey key() {
            return this.key;
        }

        @Override
        public Map<LinkKey, Link> getLink() {
            return this._link;
        }

        @Override
        public Map<NodeKey, Node> getNode() {
            return this._node;
        }

        @Override
        public Boolean getServerProvided() {
            return this._serverProvided;
        }

        @Override
        public TopologyId getTopologyId() {
            return this._topologyId;
        }

        @Override
        public TopologyTypes getTopologyTypes() {
            return this._topologyTypes;
        }

        @Override
        public Map<UnderlayTopologyKey, UnderlayTopology> getUnderlayTopology() {
            return this._underlayTopology;
        }

        @Override
        public TopologyTypes nonnullTopologyTypes() {
            return Objects.requireNonNullElse(this.getTopologyTypes(), TopologyTypesBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Topology.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Topology.bindingEquals(this, obj);
        }

        public String toString() {
            return Topology.bindingToString(this);
        }
    }
}

