/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.LinkAttributes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.LinkId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.Destination;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.DestinationBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.Source;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.SourceBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.SupportingLink;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.SupportingLinkKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.LinkKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LinkBuilder {
    private Destination _destination;
    private LinkId _linkId;
    private Source _source;
    private Map<SupportingLinkKey, SupportingLink> _supportingLink;
    private LinkKey key;
    Map<Class<? extends Augmentation<Link>>, Augmentation<Link>> augmentation = Map.of();

    public LinkBuilder() {
    }

    public LinkBuilder(LinkAttributes arg) {
        this._linkId = arg.getLinkId();
        this._source = arg.getSource();
        this._destination = arg.getDestination();
        this._supportingLink = arg.getSupportingLink();
    }

    public LinkBuilder(Link base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Link>>, Augmentation<Link>>(aug);
        }
        this.key = base.key();
        this._linkId = base.getLinkId();
        this._destination = base.getDestination();
        this._source = base.getSource();
        this._supportingLink = base.getSupportingLink();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LinkAttributes) {
            LinkAttributes castArg = (LinkAttributes)arg;
            this._linkId = castArg.getLinkId();
            this._source = castArg.getSource();
            this._destination = castArg.getDestination();
            this._supportingLink = castArg.getSupportingLink();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[LinkAttributes]");
    }

    public LinkKey key() {
        return this.key;
    }

    public Destination getDestination() {
        return this._destination;
    }

    public LinkId getLinkId() {
        return this._linkId;
    }

    public Source getSource() {
        return this._source;
    }

    public Map<SupportingLinkKey, SupportingLink> getSupportingLink() {
        return this._supportingLink;
    }

    public <E$$ extends Augmentation<Link>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public LinkBuilder withKey(LinkKey key) {
        this.key = key;
        return this;
    }

    public LinkBuilder setDestination(Destination value) {
        this._destination = value;
        return this;
    }

    public LinkBuilder setLinkId(LinkId value) {
        this._linkId = value;
        return this;
    }

    public LinkBuilder setSource(Source value) {
        this._source = value;
        return this;
    }

    public LinkBuilder setSupportingLink(Map<SupportingLinkKey, SupportingLink> values) {
        this._supportingLink = values;
        return this;
    }

    public LinkBuilder addAugmentation(Augmentation<Link> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Link>>, Augmentation<Link>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public LinkBuilder removeAugmentation(Class<? extends Augmentation<Link>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Link build() {
        return new LinkImpl(this);
    }

    private static final class LinkImpl
    extends AbstractAugmentable<Link>
    implements Link {
        private final Destination _destination;
        private final LinkId _linkId;
        private final Source _source;
        private final Map<SupportingLinkKey, SupportingLink> _supportingLink;
        private final LinkKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        LinkImpl(LinkBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new LinkKey(base.getLinkId());
            this._linkId = this.key.getLinkId();
            this._destination = base.getDestination();
            this._source = base.getSource();
            this._supportingLink = CodeHelpers.emptyToNull(base.getSupportingLink());
        }

        @Override
        public LinkKey key() {
            return this.key;
        }

        @Override
        public Destination getDestination() {
            return this._destination;
        }

        @Override
        public LinkId getLinkId() {
            return this._linkId;
        }

        @Override
        public Source getSource() {
            return this._source;
        }

        @Override
        public Map<SupportingLinkKey, SupportingLink> getSupportingLink() {
            return this._supportingLink;
        }

        @Override
        public Destination nonnullDestination() {
            return Objects.requireNonNullElse(this.getDestination(), DestinationBuilder.empty());
        }

        @Override
        public Source nonnullSource() {
            return Objects.requireNonNullElse(this.getSource(), SourceBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Link.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Link.bindingEquals(this, obj);
        }

        public String toString() {
            return Link.bindingToString(this);
        }
    }
}

