/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.node.attributes;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.node.attributes.SupportingNode;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.node.attributes.SupportingNodeKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class SupportingNodeBuilder {
    private NodeId _nodeRef;
    private TopologyId _topologyRef;
    private SupportingNodeKey key;
    Map<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>> augmentation = Map.of();

    public SupportingNodeBuilder() {
    }

    public SupportingNodeBuilder(SupportingNode base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>>(aug);
        }
        this.key = base.key();
        this._nodeRef = base.getNodeRef();
        this._topologyRef = base.getTopologyRef();
    }

    public SupportingNodeKey key() {
        return this.key;
    }

    public NodeId getNodeRef() {
        return this._nodeRef;
    }

    public TopologyId getTopologyRef() {
        return this._topologyRef;
    }

    public <E$$ extends Augmentation<SupportingNode>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public SupportingNodeBuilder withKey(SupportingNodeKey key) {
        this.key = key;
        return this;
    }

    public SupportingNodeBuilder setNodeRef(NodeId value) {
        this._nodeRef = value;
        return this;
    }

    public SupportingNodeBuilder setTopologyRef(TopologyId value) {
        this._topologyRef = value;
        return this;
    }

    public SupportingNodeBuilder addAugmentation(Augmentation<SupportingNode> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public SupportingNodeBuilder removeAugmentation(Class<? extends Augmentation<SupportingNode>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull SupportingNode build() {
        return new SupportingNodeImpl(this);
    }

    private static final class SupportingNodeImpl
    extends AbstractAugmentable<SupportingNode>
    implements SupportingNode {
        private final NodeId _nodeRef;
        private final TopologyId _topologyRef;
        private final SupportingNodeKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        SupportingNodeImpl(SupportingNodeBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new SupportingNodeKey(base.getNodeRef(), base.getTopologyRef());
            this._nodeRef = this.key.getNodeRef();
            this._topologyRef = this.key.getTopologyRef();
        }

        @Override
        public SupportingNodeKey key() {
            return this.key;
        }

        @Override
        public NodeId getNodeRef() {
            return this._nodeRef;
        }

        @Override
        public TopologyId getTopologyRef() {
            return this._topologyRef;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = SupportingNode.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return SupportingNode.bindingEquals(this, obj);
        }

        public String toString() {
            return SupportingNode.bindingToString(this);
        }
    }
}

