/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.databind;

import com.google.common.base.MoreObjects;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.security.Principal;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.databind.Request;
import org.opendaylight.netconf.databind.RequestException;

public abstract class AbstractRequest<R>
implements Request<R> {
    private static final VarHandle UUID_VH;
    private final @Nullable Principal principal;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
    private volatile UUID uuid;

    protected AbstractRequest(@Nullable Principal principal) {
        this.principal = principal;
    }

    @Override
    public final UUID uuid() {
        UUID existing = UUID_VH.getAcquire(this);
        return existing != null ? existing : this.loadUuid();
    }

    private @NonNull UUID loadUuid() {
        UUID created = UUID.randomUUID();
        UUID witness = UUID_VH.compareAndExchangeRelease(this, null, created);
        return witness != null ? witness : created;
    }

    @Override
    public final Principal principal() {
        return this.principal;
    }

    @Override
    public final void completeWith(R result) {
        this.onSuccess(Objects.requireNonNull(result));
    }

    @Override
    public final void completeWith(RequestException failure) {
        this.onFailure(Objects.requireNonNull(failure));
    }

    protected abstract void onSuccess(@NonNull R var1);

    protected abstract void onFailure(@NonNull RequestException var1);

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(this);
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MoreObjects.ToStringHelper addToStringAttributes(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MoreObjects.ToStringHelper helper) {
        helper.add("uuid", (Object)this.uuid());
        Principal tmp = this.principal;
        if (tmp != null) {
            helper.add("principal", (Object)tmp.getName());
        }
        return helper;
    }

    static {
        try {
            UUID_VH = MethodHandles.lookup().findVarHandle(AbstractRequest.class, "uuid", UUID.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

