/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.databind;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointContext;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlCodecFactory;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

public final class DatabindContext {
    private static final VarHandle JSON_CODECS;
    private static final VarHandle XML_CODECS;
    private static final VarHandle SCHEMA_TREE;
    private final @NonNull MountPointContext mountContext;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull NormalizedNode.BuilderFactory builderFactory;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
    private volatile DataSchemaContextTree schemaTree;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
    private volatile JSONCodecFactory jsonCodecs;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
    private volatile XmlCodecFactory xmlCodecs;

    @NonNullByDefault
    private DatabindContext(MountPointContext mountContext, NormalizedNode.BuilderFactory builderFactory) {
        this.mountContext = Objects.requireNonNull(mountContext);
        this.builderFactory = Objects.requireNonNull(builderFactory);
    }

    @NonNullByDefault
    public static DatabindContext ofModel(EffectiveModelContext modelContext) {
        return DatabindContext.ofMountPoint(MountPointContext.of((EffectiveModelContext)modelContext));
    }

    @NonNullByDefault
    public static DatabindContext ofModel(EffectiveModelContext modelContext, NormalizedNode.BuilderFactory builderFactory) {
        return DatabindContext.ofMountPoint(MountPointContext.of((EffectiveModelContext)modelContext), builderFactory);
    }

    @NonNullByDefault
    public static DatabindContext ofMountPoint(MountPointContext mountContext) {
        return DatabindContext.ofMountPoint(mountContext, ImmutableNodes.builderFactory());
    }

    @NonNullByDefault
    public static DatabindContext ofMountPoint(MountPointContext mountContext, NormalizedNode.BuilderFactory builderFactory) {
        return new DatabindContext(mountContext, builderFactory);
    }

    public @NonNull EffectiveModelContext modelContext() {
        return this.mountContext.modelContext();
    }

    public @NonNull MountPointContext mountContext() {
        return this.mountContext;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull NormalizedNode.BuilderFactory builderFactory() {
        return this.builderFactory;
    }

    public @NonNull DataSchemaContextTree schemaTree() {
        DataSchemaContextTree existing = SCHEMA_TREE.getAcquire(this);
        return existing != null ? existing : this.createSchemaTree();
    }

    private @NonNull DataSchemaContextTree createSchemaTree() {
        DataSchemaContextTree created = DataSchemaContextTree.from((EffectiveModelContext)this.modelContext());
        DataSchemaContextTree witness = SCHEMA_TREE.compareAndExchangeRelease(this, null, created);
        return witness != null ? witness : created;
    }

    public @NonNull JSONCodecFactory jsonCodecs() {
        JSONCodecFactory existing = JSON_CODECS.getAcquire(this);
        return existing != null ? existing : this.createJsonCodecs();
    }

    private @NonNull JSONCodecFactory createJsonCodecs() {
        JSONCodecFactory created = JSONCodecFactorySupplier.RFC7951.getShared(this.mountContext.modelContext());
        JSONCodecFactory witness = JSON_CODECS.compareAndExchangeRelease(this, null, created);
        return witness != null ? witness : created;
    }

    public @NonNull XmlCodecFactory xmlCodecs() {
        XmlCodecFactory existing = XML_CODECS.getAcquire(this);
        return existing != null ? existing : this.createXmlCodecs();
    }

    private @NonNull XmlCodecFactory createXmlCodecs() {
        XmlCodecFactory created = XmlCodecFactory.create((MountPointContext)this.mountContext);
        XmlCodecFactory witness = XML_CODECS.compareAndExchangeRelease(this, null, created);
        return witness != null ? witness : created;
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            JSON_CODECS = lookup.findVarHandle(DatabindContext.class, "jsonCodecs", JSONCodecFactory.class);
            XML_CODECS = lookup.findVarHandle(DatabindContext.class, "xmlCodecs", XmlCodecFactory.class);
            SCHEMA_TREE = lookup.findVarHandle(DatabindContext.class, "schemaTree", DataSchemaContextTree.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

