/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.databind;

import com.google.common.annotations.Beta;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.netconf.databind.DatabindContext;
import org.opendaylight.netconf.databind.ErrorPath;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContext;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.stmt.ActionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.InputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OutputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

@NonNullByDefault
public sealed interface DatabindPath {
    public DatabindContext databind();

    public SchemaInferenceStack.Inference inference();

    public static sealed interface OperationPath
    extends DatabindPath
    permits Action, Rpc {
        public InputEffectiveStatement inputStatement();

        public OutputEffectiveStatement outputStatement();
    }

    @Beta
    public static sealed interface InstanceRequest
    extends InstanceReference
    permits Action, Data {
    }

    public static sealed interface InstanceReference
    extends DatabindPath
    permits DataNodeNotification, InstanceRequest {
        public YangInstanceIdentifier instance();

        default public ErrorPath toErrorPath() {
            return new ErrorPath(this.databind(), this.instance());
        }
    }

    public record Rpc(DatabindContext databind, SchemaInferenceStack.Inference inference, RpcEffectiveStatement statement) implements OperationPath
    {
        public Rpc {
            Objects.requireNonNull(databind);
            Objects.requireNonNull(inference);
            Objects.requireNonNull(statement);
        }

        @Override
        public InputEffectiveStatement inputStatement() {
            return this.statement.input();
        }

        @Override
        public OutputEffectiveStatement outputStatement() {
            return this.statement.output();
        }
    }

    public record Notification(DatabindContext databind, SchemaInferenceStack.Inference inference, NotificationEffectiveStatement statement) implements DatabindPath
    {
        public Notification {
            Objects.requireNonNull(databind);
            Objects.requireNonNull(inference);
            Objects.requireNonNull(statement);
        }
    }

    public record DataNodeNotification(DatabindContext databind, SchemaInferenceStack.Inference inference, YangInstanceIdentifier instance, NotificationEffectiveStatement statement) implements DatabindPath,
    InstanceReference
    {
        public DataNodeNotification {
            Objects.requireNonNull(databind);
            Objects.requireNonNull(inference);
            Objects.requireNonNull(statement);
            if (instance.isEmpty()) {
                throw new IllegalArgumentException("data node notification must be instantiated on a data resource");
            }
        }
    }

    public record Data(DatabindContext databind, SchemaInferenceStack.Inference inference, YangInstanceIdentifier instance, DataSchemaContext schema) implements InstanceRequest
    {
        public Data {
            Objects.requireNonNull(databind);
            Objects.requireNonNull(inference);
            Objects.requireNonNull(instance);
            Objects.requireNonNull(schema);
        }

        public Data(DatabindContext databind) {
            this(databind, SchemaInferenceStack.Inference.ofDataTreePath((EffectiveModelContext)databind.modelContext(), (QName[])new QName[0]), YangInstanceIdentifier.of(), (DataSchemaContext)databind.schemaTree().getRoot());
        }

        public Data parent() {
            YangInstanceIdentifier parentPath = this.instance.getParent();
            if (parentPath == null) {
                return this;
            }
            return this.enterPath(parentPath);
        }

        public Data enterPath(YangInstanceIdentifier identifier) {
            DataSchemaContextTree.NodeAndStack childAndStack = (DataSchemaContextTree.NodeAndStack)this.databind.schemaTree().enterPath(identifier).orElseThrow();
            return new Data(this.databind, childAndStack.stack().toInference(), identifier, childAndStack.node());
        }
    }

    public record Action(DatabindContext databind, SchemaInferenceStack.Inference inference, YangInstanceIdentifier instance, ActionEffectiveStatement statement) implements InstanceRequest,
    OperationPath
    {
        public Action {
            Objects.requireNonNull(databind);
            Objects.requireNonNull(inference);
            Objects.requireNonNull(statement);
            if (instance.isEmpty()) {
                throw new IllegalArgumentException("action must be instantiated on a data resource");
            }
        }

        @Override
        public InputEffectiveStatement inputStatement() {
            return this.statement.input();
        }

        @Override
        public OutputEffectiveStatement outputStatement() {
            return this.statement.output();
        }
    }
}

