/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.databind;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.databind.ErrorInfo;
import org.opendaylight.netconf.databind.ErrorMessage;
import org.opendaylight.netconf.databind.ErrorPath;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.RpcError;

@NonNullByDefault
public record RequestError(ErrorType type, ErrorTag tag, @Nullable ErrorMessage message, @Nullable String appTag, @Nullable ErrorPath path, @Nullable ErrorInfo info) {
    public RequestError(ErrorType type, ErrorTag tag, @Nullable ErrorMessage message, @Nullable String appTag, @Nullable ErrorPath path, @Nullable ErrorInfo info) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(tag);
    }

    public RequestError(ErrorType type, ErrorTag tag, String message) {
        this(type, tag, new ErrorMessage(message), null, null, null);
    }

    public static RequestError ofRpcError(RpcError rpcError) {
        ErrorTag tag = rpcError.getTag();
        ErrorTag errorTag = tag != null ? tag : ErrorTag.OPERATION_FAILED;
        String errorMessage = rpcError.getMessage();
        return new RequestError(rpcError.getErrorType(), errorTag, errorMessage != null ? new ErrorMessage(errorMessage) : null, rpcError.getApplicationTag(), null, RequestError.extractErrorInfo(rpcError));
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("type", (Object)this.type).add("tag", (Object)this.tag).add("appTag", (Object)this.appTag).add("message", (Object)this.message).add("path", (Object)this.path).add("info", (Object)this.info).toString();
    }

    private static @Nullable ErrorInfo extractErrorInfo(RpcError rpcError) {
        String info = rpcError.getInfo();
        if (info != null) {
            return new ErrorInfo(info);
        }
        Throwable cause = rpcError.getCause();
        return cause != null ? new ErrorInfo(cause.getMessage()) : null;
    }
}

