/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.databind;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.databind.ErrorInfo;
import org.opendaylight.netconf.databind.ErrorMessage;
import org.opendaylight.netconf.databind.ErrorPath;
import org.opendaylight.netconf.databind.RequestError;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;

@NonNullByDefault
public final class RequestException
extends Exception {
    private static final long serialVersionUID = 0L;
    private final List<RequestError> errors;

    private RequestException(String message, RequestError error, @Nullable Throwable cause) {
        super(message, cause);
        this.errors = List.of(error);
    }

    public RequestException(String message) {
        this(ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, Objects.requireNonNull(message));
    }

    public RequestException(String format, Object ... args) {
        this(ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, format, args);
    }

    public RequestException(Throwable cause) {
        this(ErrorType.APPLICATION, RequestException.errorTagOf(cause), cause);
    }

    public RequestException(String message, @Nullable Throwable cause) {
        this(ErrorType.APPLICATION, RequestException.errorTagOf(cause), Objects.requireNonNull(message), cause);
    }

    public RequestException(ErrorType type, ErrorTag tag, String message) {
        this(type, tag, message, (Throwable)null);
    }

    public RequestException(ErrorType type, ErrorTag tag, Throwable cause) {
        this(cause.toString(), new RequestError(type, tag, new ErrorMessage(cause.getMessage()), null, null, null), cause);
    }

    public RequestException(ErrorType type, ErrorTag tag, String message, @Nullable Throwable cause) {
        this(Objects.requireNonNull(message), new RequestError(type, tag, new ErrorMessage(message), null, null, RequestException.errorInfoOf(cause)), cause);
    }

    public RequestException(ErrorType type, ErrorTag tag, String format, Object ... args) {
        this(type, tag, format.formatted(args));
    }

    public RequestException(ErrorType type, ErrorTag tag, String message, @Nullable ErrorPath path) {
        this(type, tag, message, path, null);
    }

    public RequestException(ErrorType type, ErrorTag tag, String message, @Nullable ErrorPath path, @Nullable Throwable cause) {
        this(message, new RequestError(type, tag, new ErrorMessage(message), null, path, RequestException.errorInfoOf(cause)), cause);
    }

    public RequestException(List<RequestError> errors, @Nullable Throwable cause, String message) {
        super(message, cause);
        this.errors = Objects.requireNonNull(errors);
        if (errors.isEmpty()) {
            throw new IllegalArgumentException("empty errors");
        }
    }

    public RequestException(List<RequestError> errors, @Nullable Throwable cause, String format, Object ... args) {
        this(errors, cause, format.formatted(args));
    }

    public List<RequestError> errors() {
        return this.errors;
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new NotSerializableException();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        throw new NotSerializableException();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        throw new NotSerializableException();
    }

    private static @Nullable ErrorInfo errorInfoOf(@Nullable Throwable cause) {
        String message;
        if (cause != null && (message = cause.getMessage()) != null) {
            return new ErrorInfo(message);
        }
        return null;
    }

    private static ErrorTag errorTagOf(@Nullable Throwable cause) {
        Throwable throwable = cause;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IllegalArgumentException.class, UnsupportedOperationException.class}, (Object)throwable, n)) {
            case 0 -> {
                IllegalArgumentException iae = (IllegalArgumentException)throwable;
                yield ErrorTag.INVALID_VALUE;
            }
            case 1 -> {
                UnsupportedOperationException uoe = (UnsupportedOperationException)throwable;
                yield ErrorTag.OPERATION_NOT_SUPPORTED;
            }
            default -> ErrorTag.OPERATION_FAILED;
        };
    }
}

