/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.databind.subtree;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.databind.subtree.ContentMatchNode;
import org.opendaylight.netconf.databind.subtree.NamespaceSelection;
import org.opendaylight.netconf.databind.subtree.SelectionNode;
import org.opendaylight.netconf.databind.subtree.Sibling;
import org.opendaylight.netconf.databind.subtree.SiblingSet;
import org.opendaylight.netconf.databind.subtree.SiblingSetBuilder;

@NonNullByDefault
public final class ContainmentNode
implements Sibling,
SiblingSet {
    private final NamespaceSelection selection;
    private final List<ContentMatchNode> contentMatches;
    private final List<ContainmentNode> containments;
    private final List<SelectionNode> selections;

    private ContainmentNode(Builder builder) {
        this.selection = builder.selection;
        this.contentMatches = builder.siblings(ContentMatchNode.class);
        this.containments = builder.siblings(ContainmentNode.class);
        this.selections = builder.siblings(SelectionNode.class);
    }

    public static Builder builder(NamespaceSelection selection) {
        return new Builder(selection);
    }

    @Override
    public NamespaceSelection selection() {
        return this.selection;
    }

    @Override
    public List<ContentMatchNode> contentMatches() {
        return this.contentMatches;
    }

    @Override
    public List<ContainmentNode> containments() {
        return this.containments;
    }

    @Override
    public List<SelectionNode> selections() {
        return this.selections;
    }

    public int hashCode() {
        return Objects.hash(this.selection, this.contentMatches, this.containments, this.selections);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof ContainmentNode)) return false;
        ContainmentNode other = (ContainmentNode)obj;
        if (!this.selection.equals(other.selection)) return false;
        if (!this.contentMatches.equals(other.contentMatches)) return false;
        if (!this.containments.equals(other.containments)) return false;
        if (!this.selections.equals(other.selections)) return false;
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("selection", (Object)this.selection).add("siblings", this.siblings()).toString();
    }

    public static final class Builder
    extends SiblingSetBuilder {
        private final NamespaceSelection selection;

        private Builder(NamespaceSelection selection) {
            this.selection = Objects.requireNonNull(selection);
        }

        public Builder add(Sibling sibling) {
            this.addSibling(sibling);
            return this;
        }

        public ContainmentNode build() {
            return new ContainmentNode(this);
        }
    }
}

